/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdDefTemplate;
import org.jrobin.core.Sample;

public class RRDWriter
extends BaseOutputWriter {
    private final File outputFile;
    private final File templateFile;

    @JsonCreator
    public RRDWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="outputFile") String outputFile, @JsonProperty(value="templateFile") String templateFile, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.outputFile = new File((String)MoreObjects.firstNonNull((Object)outputFile, (Object)((String)this.getSettings().get("outputFile"))));
        this.templateFile = new File((String)MoreObjects.firstNonNull((Object)templateFile, (Object)((String)this.getSettings().get("templateFile"))));
        Preconditions.checkState((boolean)this.outputFile.exists(), (Object)"Output file must exist");
        Preconditions.checkState((boolean)this.templateFile.exists(), (Object)"Template file must exist");
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        try (RrdDb db = null;){
            db = this.createOrOpenDatabase();
            Sample sample = db.createSample();
            List<String> dsNames = Arrays.asList(db.getDsNames());
            for (Result res : results) {
                for (Map.Entry entry : res.getValues().entrySet()) {
                    if (!dsNames.contains(entry.getKey()) || !NumberUtils.isNumeric(entry.getValue())) continue;
                    sample.setValue((String)entry.getKey(), Double.valueOf(entry.getValue().toString()).doubleValue());
                }
            }
            sample.update();
        }
    }

    protected RrdDb createOrOpenDatabase() throws Exception {
        RrdDb result;
        if (!this.outputFile.exists()) {
            FileUtils.forceMkdir((File)this.outputFile.getParentFile());
            RrdDefTemplate t = new RrdDefTemplate(this.templateFile);
            t.setVariable("database", this.outputFile.getCanonicalPath());
            RrdDef def = t.getRrdDef();
            result = new RrdDb(def);
        } else {
            result = new RrdDb(this.outputFile.getCanonicalPath());
        }
        return result;
    }

    public String getTemplateFile() {
        return this.templateFile.getPath();
    }

    public String getOutputFile() {
        return this.outputFile.getPath();
    }
}

