/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.ResultAttribute;
import com.googlecode.jmxtrans.model.ResultAttributes;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.kafka.ResultSerializer;
import com.googlecode.jmxtrans.util.NumberUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResultSerializer
implements ResultSerializer {
    private static final Logger log = LoggerFactory.getLogger(DefaultResultSerializer.class);
    private final JsonFactory jsonFactory = new JsonFactory();
    @Nonnull
    private final ImmutableList<String> typeNames;
    private final boolean booleanAsNumber;
    @Nonnull
    private final String rootPrefix;
    @Nonnull
    private final ImmutableMap<String, String> tags;
    @Nonnull
    private final ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags;

    @JsonCreator
    public DefaultResultSerializer(@JsonProperty(value="typeNames") List<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="resultTags") List<String> resultTags) {
        this.typeNames = typeNames == null ? ImmutableList.of() : ImmutableList.copyOf(typeNames);
        this.booleanAsNumber = booleanAsNumber;
        this.rootPrefix = rootPrefix;
        this.tags = tags == null ? ImmutableMap.of() : ImmutableMap.copyOf(tags);
        this.resultAttributesToWriteAsTags = resultTags == null ? ImmutableSet.of() : ResultAttributes.forNames(resultTags);
    }

    @Override
    @Nonnull
    public Collection<String> serialize(Server server, Query query, Result result) throws IOException {
        log.debug("Query result: [{}]", (Object)result);
        ImmutableMap resultValues = result.getValues();
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : resultValues.entrySet()) {
            Object value = entry.getValue();
            if (NumberUtils.isNumeric(value)) {
                messages.add(this.createJsonMessage(server, query, result, entry, value));
                continue;
            }
            log.warn("Unable to submit non-numeric value to Kafka: [{}] from result [{}]", value, (Object)result);
        }
        return messages;
    }

    /*
     * Exception decompiling
     */
    private String createJsonMessage(Server server, Query query, Result result, Map.Entry<String, Object> values, Object value) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultResultSerializer)) {
            return false;
        }
        DefaultResultSerializer other = (DefaultResultSerializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.getTypeNames();
        ImmutableList<String> other$typeNames = other.getTypeNames();
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        if (this.isBooleanAsNumber() != other.isBooleanAsNumber()) {
            return false;
        }
        String this$rootPrefix = this.getRootPrefix();
        String other$rootPrefix = other.getRootPrefix();
        if (this$rootPrefix == null ? other$rootPrefix != null : !this$rootPrefix.equals(other$rootPrefix)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        ImmutableSet<ResultAttribute> this$resultAttributesToWriteAsTags = this.resultAttributesToWriteAsTags;
        ImmutableSet<ResultAttribute> other$resultAttributesToWriteAsTags = other.resultAttributesToWriteAsTags;
        return !(this$resultAttributesToWriteAsTags == null ? other$resultAttributesToWriteAsTags != null : !this$resultAttributesToWriteAsTags.equals(other$resultAttributesToWriteAsTags));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof DefaultResultSerializer;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<String> $typeNames = this.getTypeNames();
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        result = result * 59 + (this.isBooleanAsNumber() ? 79 : 97);
        String $rootPrefix = this.getRootPrefix();
        result = result * 59 + ($rootPrefix == null ? 43 : $rootPrefix.hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        ImmutableSet<ResultAttribute> $resultAttributesToWriteAsTags = this.resultAttributesToWriteAsTags;
        result = result * 59 + ($resultAttributesToWriteAsTags == null ? 43 : $resultAttributesToWriteAsTags.hashCode());
        return result;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<String> getTypeNames() {
        return this.typeNames;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isBooleanAsNumber() {
        return this.booleanAsNumber;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public String getRootPrefix() {
        return this.rootPrefix;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }
}

