/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.kafka.ResultSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

public class DetailedResultSerializer
implements ResultSerializer {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final boolean singleValue;

    @JsonCreator
    public DetailedResultSerializer(@JsonProperty(value="singleValue", defaultValue="false") boolean singleValue) {
        this.singleValue = singleValue;
    }

    @Override
    @Nonnull
    public Collection<String> serialize(Server server, Query query, Result result) throws IOException {
        if (this.singleValue) {
            ArrayList<String> messages = new ArrayList<String>();
            for (String valueName : result.getValues().keySet()) {
                messages.add(this.objectMapper.writeValueAsString((Object)new SingleValueResult(server, result, valueName)));
            }
            return messages;
        }
        return Collections.singletonList(this.objectMapper.writeValueAsString((Object)new MultiValuesResult(server, result)));
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedResultSerializer)) {
            return false;
        }
        DetailedResultSerializer other = (DetailedResultSerializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isSingleValue() == other.isSingleValue();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof DetailedResultSerializer;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSingleValue() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isSingleValue() {
        return this.singleValue;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @Immutable
    @ThreadSafe
    private static class SingleValueResult
    extends KResult {
        private final String valueName;
        private final Object value;

        private SingleValueResult(Server server, Result result, String valueName) {
            super(server, result);
            this.valueName = valueName;
            this.value = result.getValues().get((Object)valueName);
        }

        @SuppressFBWarnings(justification="generated code")
        public String getValueName() {
            return this.valueName;
        }

        @SuppressFBWarnings(justification="generated code")
        public Object getValue() {
            return this.value;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @Immutable
    @ThreadSafe
    private static class MultiValuesResult
    extends KResult {
        private final ImmutableMap<String, Object> values;

        private MultiValuesResult(Server server, Result result) {
            super(server, result);
            this.values = result.getValues();
        }

        @SuppressFBWarnings(justification="generated code")
        public ImmutableMap<String, Object> getValues() {
            return this.values;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @Immutable
    @ThreadSafe
    private static abstract class KResult {
        private final String alias;
        private final String pid;
        private final String host;
        private final String port;
        private final String source;
        private final String attributeName;
        private final String className;
        private final String objDomain;
        private final String typeName;
        private final Map<String, String> typeNameMap;
        private final long epoch;
        private final String keyAlias;

        private KResult(Server server, Result result) {
            this.alias = server.getAlias();
            this.pid = server.getPid();
            this.host = server.getHost();
            this.port = server.getPort();
            this.source = server.getSource();
            this.attributeName = result.getAttributeName();
            this.className = result.getClassName();
            this.objDomain = result.getObjDomain();
            this.typeName = result.getTypeName();
            this.typeNameMap = result.getTypeNameMap();
            this.epoch = result.getEpoch();
            this.keyAlias = result.getKeyAlias();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getAlias() {
            return this.alias;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getPid() {
            return this.pid;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getHost() {
            return this.host;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getPort() {
            return this.port;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSource() {
            return this.source;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getAttributeName() {
            return this.attributeName;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getClassName() {
            return this.className;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getObjDomain() {
            return this.objDomain;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getTypeName() {
            return this.typeName;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<String, String> getTypeNameMap() {
            return this.typeNameMap;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getEpoch() {
            return this.epoch;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getKeyAlias() {
            return this.keyAlias;
        }
    }
}

