/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.kafka.ResultSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaWriter2
extends OutputWriterAdapter {
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final Map<String, Object> producerConfig;
    @Nonnull
    private final String topic;
    private final Producer<String, String> producer;
    @Nonnull
    private final ResultSerializer resultSerializer;

    public KafkaWriter2(@Nonnull ObjectMapper objectMapper, @Nonnull Map<String, Object> producerConfig, @Nonnull String topic, @Nonnull ResultSerializer resultSerializer) {
        this.objectMapper = objectMapper;
        this.producerConfig = producerConfig;
        this.topic = topic;
        this.resultSerializer = resultSerializer;
        this.producer = new KafkaProducer(producerConfig);
    }

    @VisibleForTesting
    KafkaWriter2(@Nonnull ObjectMapper objectMapper, Producer<String, String> producer, @Nonnull String topic, @Nonnull ResultSerializer resultSerializer) {
        this.objectMapper = objectMapper;
        this.producerConfig = Collections.emptyMap();
        this.topic = topic;
        this.resultSerializer = resultSerializer;
        this.producer = producer;
    }

    public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
        for (Result result : results) {
            for (String message : this.resultSerializer.serialize(server, query, result)) {
                this.producer.send(new ProducerRecord(this.topic, (Object)message));
            }
        }
    }

    public void close() throws LifecycleException {
        this.producer.close();
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public String getTopic() {
        return this.topic;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ResultSerializer getResultSerializer() {
        return this.resultSerializer;
    }
}

