/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.kafka.DefaultResultSerializer;
import com.googlecode.jmxtrans.model.output.kafka.KafkaWriter2;
import com.googlecode.jmxtrans.model.output.kafka.ResultSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaWriterFactory
implements OutputWriterFactory<KafkaWriter2> {
    @Nonnull
    @JsonIgnore
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Nonnull
    private final Map<String, Object> producerConfig;
    @Nonnull
    private final String topic;
    @Nonnull
    private final ResultSerializer resultSerializer;
    private static final String STRING_SERIALIZER_CLASS = StringSerializer.class.getName();

    @JsonCreator
    public KafkaWriterFactory(@JsonProperty(value="producerConfig") @Nonnull Map<String, Object> producerConfig, @JsonProperty(value="topic") @Nonnull String topic, @JsonProperty(value="resultSerializer") ResultSerializer resultSerializer) {
        ImmutableMap.Builder producerConfigBuilder = ImmutableMap.builder().putAll(producerConfig);
        if (!producerConfig.containsKey("key.serializer")) {
            producerConfigBuilder.put((Object)"key.serializer", (Object)STRING_SERIALIZER_CLASS);
        }
        if (!producerConfig.containsKey("value.serializer")) {
            producerConfigBuilder.put((Object)"value.serializer", (Object)STRING_SERIALIZER_CLASS);
        }
        this.producerConfig = producerConfigBuilder.build();
        this.topic = topic;
        Preconditions.checkNotNull((Object)topic);
        this.resultSerializer = resultSerializer == null ? new DefaultResultSerializer(Collections.emptyList(), false, "", Collections.emptyMap(), Collections.emptyList()) : resultSerializer;
    }

    @Nonnull
    public KafkaWriter2 create() {
        return new KafkaWriter2(this.objectMapper, this.producerConfig, this.topic, this.resultSerializer);
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaWriterFactory)) {
            return false;
        }
        KafkaWriterFactory other = (KafkaWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$producerConfig = this.getProducerConfig();
        Map<String, Object> other$producerConfig = other.getProducerConfig();
        if (this$producerConfig == null ? other$producerConfig != null : !((Object)this$producerConfig).equals(other$producerConfig)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        ResultSerializer this$resultSerializer = this.getResultSerializer();
        ResultSerializer other$resultSerializer = other.getResultSerializer();
        return !(this$resultSerializer == null ? other$resultSerializer != null : !this$resultSerializer.equals(other$resultSerializer));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof KafkaWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $producerConfig = this.getProducerConfig();
        result = result * 59 + ($producerConfig == null ? 43 : ((Object)$producerConfig).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        ResultSerializer $resultSerializer = this.getResultSerializer();
        result = result * 59 + ($resultSerializer == null ? 43 : $resultSerializer.hashCode());
        return result;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public String getTopic() {
        return this.topic;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ResultSerializer getResultSerializer() {
        return this.resultSerializer;
    }
}

