/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.ResultSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

public class DetailedResultSerializer
implements ResultSerializer {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @JsonCreator
    public DetailedResultSerializer() {
    }

    public String serialize(Server server, Query query, Result result) throws IOException {
        return this.objectMapper.writeValueAsString((Object)new KResult(server, result));
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedResultSerializer)) {
            return false;
        }
        DetailedResultSerializer other = (DetailedResultSerializer)o;
        return other.canEqual(this);
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof DetailedResultSerializer;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int result = 1;
        return result;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @Immutable
    @ThreadSafe
    private static class KResult {
        private final String alias;
        private final String pid;
        private final String host;
        private final String port;
        private final String source;
        private final String attributeName;
        private final String className;
        private final String objDomain;
        private final String typeName;
        private final Map<String, String> typeNameMap;
        private final long epoch;
        private final String keyAlias;
        private final ImmutableList<String> valuePath;
        private final Object value;

        private KResult(Server server, Result result) {
            this.alias = server.getAlias();
            this.pid = server.getPid();
            this.host = server.getHost();
            this.port = server.getPort();
            this.source = server.getSource();
            this.attributeName = result.getAttributeName();
            this.className = result.getClassName();
            this.objDomain = result.getObjDomain();
            this.typeName = result.getTypeName();
            this.typeNameMap = result.getTypeNameMap();
            this.epoch = result.getEpoch();
            this.keyAlias = result.getKeyAlias();
            this.valuePath = result.getValuePath();
            this.value = result.getValue();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getAlias() {
            return this.alias;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getPid() {
            return this.pid;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getHost() {
            return this.host;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getPort() {
            return this.port;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSource() {
            return this.source;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getAttributeName() {
            return this.attributeName;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getClassName() {
            return this.className;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getObjDomain() {
            return this.objDomain;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getTypeName() {
            return this.typeName;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<String, String> getTypeNameMap() {
            return this.typeNameMap;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getEpoch() {
            return this.epoch;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getKeyAlias() {
            return this.keyAlias;
        }

        @SuppressFBWarnings(justification="generated code")
        public ImmutableList<String> getValuePath() {
            return this.valuePath;
        }

        @SuppressFBWarnings(justification="generated code")
        public Object getValue() {
            return this.value;
        }
    }
}

