/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.naming.StringUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class Log4JWriter
extends BaseOutputWriter {
    private final Logger log;
    private final String logger;

    @JsonCreator
    public Log4JWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="logger") String logger, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.logger = (String)this.firstNonNull(logger, (String)this.getSettings().get("logger"), "Log4JWriter");
        this.log = Logger.getLogger((String)("Log4JWriter." + this.logger));
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        List typeNames = this.getTypeNames();
        for (Result result : results) {
            ImmutableMap resultValues = result.getValues();
            if (resultValues == null) continue;
            for (Map.Entry values : resultValues.entrySet()) {
                String alias;
                if (!NumberUtils.isNumeric(values.getValue())) continue;
                if (server.getAlias() != null) {
                    alias = server.getAlias();
                } else {
                    alias = server.getHost() + "_" + server.getPort();
                    alias = StringUtils.cleanupStr((String)alias);
                }
                MDC.put((String)"server", (Object)alias);
                MDC.put((String)"metric", (Object)KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, values, (List)typeNames, null));
                MDC.put((String)"value", values.getValue());
                if (result.getKeyAlias() != null) {
                    MDC.put((String)"resultAlias", (Object)result.getKeyAlias());
                }
                MDC.put((String)"attributeName", (Object)result.getAttributeName());
                MDC.put((String)"key", values.getKey());
                MDC.put((String)"Epoch", (Object)String.valueOf(result.getEpoch()));
                this.log.info((Object)"");
            }
        }
    }

    public String getLogger() {
        return this.logger;
    }
}

