/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.PropertyResolver;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggerFactory;

public class NagiosWriter
extends BaseOutputWriter {
    protected static final String LOG_PATTERN = "%m%n";
    protected static final int LOG_IO_BUFFER_SIZE_BYTES = 1024;
    private static final String NAGIOS_HOST = "nagiosHost";
    private static final String PREFIX = "prefix";
    private static final String POSFIX = "posfix";
    private static final String FILTERS = "filters";
    private static final String THRESHOLDS = "thresholds";
    protected final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private final ImmutableList<String> filters;
    private final ImmutableList<String> thresholds;
    private final String nagiosHost;
    private final File outputFile;
    private final String prefix;
    private final String suffix;
    protected Logger logger;

    @JsonCreator
    public NagiosWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="filters") List<String> filters, @JsonProperty(value="thresholds") List<String> thresholds, @JsonProperty(value="nagiosHost") String nagiosHost, @JsonProperty(value="outputFile") String outputFile, @JsonProperty(value="prefix") String prefix, @JsonProperty(value="suffix") String suffix, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.filters = PropertyResolver.resolveList((List)((List)this.firstNonNull(filters, (List)this.getSettings().get(FILTERS), ImmutableList.of())));
        this.thresholds = PropertyResolver.resolveList((List)((List)this.firstNonNull(thresholds, (List)this.getSettings().get(THRESHOLDS), ImmutableList.of())));
        this.nagiosHost = (String)MoreObjects.firstNonNull((Object)nagiosHost, (Object)((String)this.getSettings().get(NAGIOS_HOST)));
        this.outputFile = new File((String)MoreObjects.firstNonNull((Object)outputFile, (Object)((String)this.getSettings().get("outputFile"))));
        this.prefix = (String)this.firstNonNull(prefix, (String)this.getSettings().get(PREFIX), "");
        this.suffix = (String)this.firstNonNull(suffix, (String)this.getSettings().get(POSFIX), "");
        if (filters.size() != thresholds.size()) {
            throw new IllegalStateException("filters and thresholds must have the same size.");
        }
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        this.checkFile(query);
    }

    public void checkFile(Query query) throws ValidationException {
        if (!this.outputFile.exists()) {
            if (this.loggers.containsKey("/dev/null")) {
                this.logger = this.loggers.get("/dev/null");
            } else {
                try {
                    this.logger = this.initLogger("/dev/null");
                    this.loggers.put("/dev/null", this.logger);
                }
                catch (IOException e) {
                    throw new ValidationException("Failed to setup log4j", query);
                }
            }
            if (this.loggers.containsKey(this.outputFile.getAbsolutePath())) {
                this.loggers.remove(this.outputFile.getAbsolutePath());
            }
            return;
        }
        if (this.loggers.containsKey(this.outputFile.getAbsolutePath())) {
            this.logger = this.loggers.get(this.outputFile.getAbsolutePath());
            return;
        }
        try {
            this.logger = this.initLogger(this.outputFile.getAbsolutePath());
            this.loggers.put(this.outputFile.getAbsolutePath(), this.logger);
        }
        catch (IOException e) {
            throw new ValidationException("Failed to setup log4j", query);
        }
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.checkFile(query);
        List typeNames = this.getTypeNames();
        for (Result result : results) {
            ImmutableMap resultValues = result.getValues();
            if (resultValues == null) continue;
            for (Map.Entry values : resultValues.entrySet()) {
                String[] str_array = KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, values, (List)typeNames, null).split("\\.");
                if (!NumberUtils.isNumeric(values.getValue()) || !this.filters.contains((Object)str_array[2])) continue;
                int threshold_pos = this.filters.indexOf((Object)str_array[2]);
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                sb.append(result.getEpoch());
                sb.append("] PROCESS_SERVICE_CHECK_RESULT;");
                sb.append(this.nagiosHost);
                sb.append(";");
                if (this.prefix != null) {
                    sb.append(this.prefix);
                }
                sb.append(str_array[2]);
                if (this.suffix != null) {
                    sb.append(this.suffix);
                }
                sb.append(";");
                sb.append(this.nagiosCheckValue(values.getValue().toString(), (String)this.thresholds.get(threshold_pos)));
                sb.append(";");
                this.logger.info((Object)sb.toString());
            }
        }
    }

    protected Logger initLogger(String fileStr) throws IOException {
        PatternLayout pl = new PatternLayout(LOG_PATTERN);
        final FileAppender appender = new FileAppender((Layout)pl, fileStr, true);
        appender.setBufferedIO(false);
        appender.setBufferSize(1024);
        LoggerFactory loggerFactory = new LoggerFactory(){

            public Logger makeNewLoggerInstance(String name) {
                Logger logger = Logger.getLogger((String)name);
                logger.addAppender((Appender)appender);
                logger.setLevel(Level.INFO);
                logger.setAdditivity(false);
                return logger;
            }
        };
        return loggerFactory.makeNewLoggerInstance("NagiosWriter" + ((Object)((Object)this)).hashCode());
    }

    protected String nagiosCheckValue(String value, String composeRange) {
        List<String> simpleRange = Arrays.asList(composeRange.split(","));
        double value_d = Double.parseDouble(value);
        if (composeRange.isEmpty()) {
            return "0";
        }
        if (simpleRange.size() == 1) {
            if (composeRange.endsWith(",")) {
                if (this.valueCheck(value_d, simpleRange.get(0))) {
                    return "1";
                }
                return "0";
            }
            if (this.valueCheck(value_d, simpleRange.get(0))) {
                return "2";
            }
            return "0";
        }
        if (this.valueCheck(value_d, simpleRange.get(1))) {
            return "2";
        }
        if (this.valueCheck(value_d, simpleRange.get(0))) {
            return "1";
        }
        return "0";
    }

    protected boolean valueCheck(double value, String simpleRange) {
        if (simpleRange.isEmpty()) {
            return false;
        }
        if (simpleRange.endsWith(":")) {
            return value < Double.parseDouble(simpleRange.replace(":", ""));
        }
        if (simpleRange.startsWith("~:")) {
            return value > Double.parseDouble(simpleRange.replace("~:", ""));
        }
        if (simpleRange.startsWith("@")) {
            String[] values = simpleRange.replace("@", "").split(":");
            return value >= Double.parseDouble(values[0]) && value <= Double.parseDouble(values[1]);
        }
        if (simpleRange.matches("^-{0,1}[0-9]+:-{0,1}[0-9]+$")) {
            String[] values = simpleRange.split(":");
            return value < Double.parseDouble(values[0]) || value > Double.parseDouble(values[1]);
        }
        return simpleRange.matches("^-{0,1}[0-9]+$") && (0.0 > value || value > Double.parseDouble(simpleRange));
    }

    public ImmutableList<String> getFilters() {
        return this.filters;
    }

    public ImmutableList<String> getThresholds() {
        return this.thresholds;
    }

    public String getNagiosHost() {
        return this.nagiosHost;
    }

    public String getOutputFile() {
        return this.outputFile.getPath();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

