/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.output.KeyOutWriter;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;

public class TimeBasedRollingKeyOutWriter
extends KeyOutWriter {
    private static final LoggerContext loggerContext = new LoggerContext();
    private static final String DEFAULT_OUTPUT_PATTERN = "%msg%n";
    private static final String SETTING_OUTPUT_PATTERN = "outputPattern";

    @JsonCreator
    public TimeBasedRollingKeyOutWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="outputFile") String outputFile, @JsonProperty(value="maxLogFileSize") String maxLogFileSize, @JsonProperty(value="maxLogBackupFiles") int maxLogBackupFiles, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, outputFile, maxLogFileSize, maxLogBackupFiles, delimiter, settings);
    }

    @Override
    protected Logger initLogger(String fileStr) throws IOException {
        RollingPolicy rollingPolicy = this.initRollingPolicy(fileStr, this.getMaxLogBackupFiles(), this.getMaxLogFileSize());
        RollingFileAppender appender = this.buildAppender(this.buildEncoder(), rollingPolicy);
        rollingPolicy.start();
        appender.start();
        return this.getAndConfigureLogger((Appender)appender);
    }

    private RollingFileAppender buildAppender(Encoder encoder, RollingPolicy rollingPolicy) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setEncoder(encoder);
        appender.setAppend(true);
        appender.setContext((Context)loggerContext);
        appender.setRollingPolicy(rollingPolicy);
        rollingPolicy.setParent((FileAppender)appender);
        return appender;
    }

    protected Logger getAndConfigureLogger(Appender appender) {
        ch.qos.logback.classic.Logger loggerLocal = loggerContext.getLogger(this.buildLoggerName());
        loggerLocal.setAdditive(false);
        loggerLocal.setLevel(Level.INFO);
        loggerLocal.addAppender(appender);
        return loggerLocal;
    }

    protected Encoder buildEncoder() {
        PatternLayoutEncoder logEncoder = new PatternLayoutEncoder();
        logEncoder.setContext((Context)loggerContext);
        logEncoder.setPattern(this.getSettingOutputPattern());
        logEncoder.start();
        return logEncoder;
    }

    protected RollingPolicy initRollingPolicy(String fileName, int maxBackupFiles, String maxFileSize) {
        SizeAndTimeBasedFNATP sizeTimeBasedPolicy = new SizeAndTimeBasedFNATP();
        sizeTimeBasedPolicy.setMaxFileSize(maxFileSize);
        sizeTimeBasedPolicy.setContext((Context)loggerContext);
        TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
        policy.setFileNamePattern(fileName);
        policy.setMaxHistory(maxBackupFiles);
        policy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)sizeTimeBasedPolicy);
        policy.setContext((Context)loggerContext);
        return policy;
    }

    protected String getSettingOutputPattern() {
        String outputPattern = (String)this.getSettings().get(SETTING_OUTPUT_PATTERN);
        if (outputPattern == null) {
            return DEFAULT_OUTPUT_PATTERN;
        }
        return outputPattern;
    }
}

