/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.output.KeyOutWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;

public class DailyKeyOutWriter
extends KeyOutWriter {
    private static final String DATE_PATTERN = "'.'yyyy-MM-dd";
    private final String datePattern;

    @JsonCreator
    public DailyKeyOutWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="outputFile") String outputFile, @JsonProperty(value="maxLogFileSize") String maxLogFileSize, @JsonProperty(value="maxLogBackupFiles") Integer maxLogBackupFiles, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="datePattern") String datePattern, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, outputFile, maxLogFileSize, maxLogBackupFiles, delimiter, settings);
        this.datePattern = (String)this.firstNonNull(datePattern, (String)this.getSettings().get("datePattern"), DATE_PATTERN);
    }

    @Override
    protected Appender buildLog4jAppender(String fileStr, String maxLogFileSize, Integer maxLogBackupFiles) throws IOException {
        return new DailyRollingFileAppender((Layout)new PatternLayout("%m%n"), fileStr, this.datePattern);
    }

    @Override
    protected String buildLoggerName() {
        return "DailyKeyOutWriter" + ((Object)((Object)this)).hashCode();
    }

    public String getDatePattern() {
        return this.datePattern;
    }
}

