/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import ch.qos.logback.core.util.FileSize;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

public class KeyOutWriter
extends BaseOutputWriter {
    protected static final Log4jLoggerFactory log4jLoggerFactory = new Log4jLoggerFactory();
    protected static final String SETTING_MAX_LOG_FILE_SIZE = "maxLogFileSize";
    protected static final String SETTING_MAX_BACK_FILES = "maxLogBackupFiles";
    protected static final String SETTING_DELIMITER = "delimiter";
    protected static final String LOG_PATTERN = "%m%n";
    protected static final int LOG_IO_BUFFER_SIZE_BYTES = 1024;
    protected static final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    protected static final int MAX_LOG_BACKUP_FILES = 200;
    protected static final String MAX_LOG_FILE_SIZE = "10MB";
    protected static final String DEFAULT_DELIMITER = "\t";
    protected Logger logger;
    private final String outputFile;
    private final FileSize maxLogFileSize;
    private final int maxLogBackupFiles;
    private final String delimiter;

    @JsonCreator
    public KeyOutWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="outputFile") String outputFile, @JsonProperty(value="maxLogFileSize") String maxLogFileSize, @JsonProperty(value="maxLogBackupFiles") Integer maxLogBackupFiles, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.outputFile = (String)MoreObjects.firstNonNull((Object)outputFile, (Object)((String)this.getSettings().get("outputFile")));
        this.maxLogFileSize = this.toFileSize((String)this.firstNonNull(maxLogFileSize, (String)this.getSettings().get(SETTING_MAX_LOG_FILE_SIZE), MAX_LOG_FILE_SIZE));
        this.maxLogBackupFiles = (Integer)this.firstNonNull(maxLogBackupFiles, (Integer)this.getSettings().get(SETTING_MAX_BACK_FILES), 200);
        this.delimiter = (String)this.firstNonNull(delimiter, (String)this.getSettings().get(SETTING_DELIMITER), DEFAULT_DELIMITER);
    }

    private FileSize toFileSize(String s) {
        return new FileSize(Long.parseLong(s));
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        if (loggers.containsKey(this.outputFile)) {
            this.logger = loggers.get(this.outputFile);
            return;
        }
        try {
            this.logger = this.initLogger(this.outputFile);
            loggers.put(this.outputFile, this.logger);
        }
        catch (IOException e) {
            throw new ValidationException("Failed to setup log4j", query, (Throwable)e);
        }
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        ImmutableList typeNames = this.getTypeNames();
        for (Result result : results) {
            ImmutableMap resultValues = result.getValues();
            for (Map.Entry values : resultValues.entrySet()) {
                if (!NumberUtils.isNumeric(values.getValue())) continue;
                this.logger.info(KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, values, (List)typeNames, null) + this.delimiter + values.getValue().toString() + this.delimiter + result.getEpoch());
            }
        }
    }

    protected Logger initLogger(String fileStr) throws IOException {
        Appender appender = this.buildLog4jAppender(fileStr, this.getMaxLogFileSize(), this.getMaxLogBackupFiles());
        LoggerFactory loggerFactory = this.buildLog4jLoggerFactory(appender);
        String loggerKey = this.buildLoggerName();
        LogManager.getLogger((String)loggerKey, (LoggerFactory)loggerFactory);
        return log4jLoggerFactory.getLogger(loggerKey);
    }

    protected String buildLoggerName() {
        return "KeyOutWriter" + ((Object)((Object)this)).hashCode();
    }

    protected Appender buildLog4jAppender(String fileStr, FileSize maxLogFileSize, Integer maxLogBackupFiles) throws IOException {
        PatternLayout pl = new PatternLayout(LOG_PATTERN);
        RollingFileAppender appender = new RollingFileAppender((Layout)pl, fileStr, true);
        appender.setImmediateFlush(true);
        appender.setBufferedIO(false);
        appender.setBufferSize(1024);
        appender.setMaxFileSize(Long.toString(maxLogFileSize.getSize()));
        appender.setMaxBackupIndex(maxLogBackupFiles.intValue());
        return appender;
    }

    protected LoggerFactory buildLog4jLoggerFactory(final Appender appender) {
        return new LoggerFactory(){

            public org.apache.log4j.Logger makeNewLoggerInstance(String name) {
                org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)name);
                logger.addAppender(appender);
                logger.setLevel(Level.INFO);
                logger.setAdditivity(false);
                return logger;
            }
        };
    }

    public FileSize getMaxLogFileSize() {
        return this.maxLogFileSize;
    }

    public Integer getMaxLogBackupFiles() {
        return this.maxLogBackupFiles;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getOutputFile() {
        return this.outputFile;
    }
}

