/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.output.KeyOutWriter;
import java.util.Map;

public class DailyKeyOutWriter
extends KeyOutWriter {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private final String datePattern;

    @JsonCreator
    public DailyKeyOutWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="outputFile") String outputFile, @JsonProperty(value="maxLogFileSize") String maxLogFileSize, @JsonProperty(value="maxLogBackupFiles") Integer maxLogBackupFiles, @JsonProperty(value="logPattern") String logPattern, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="datePattern") String datePattern, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, outputFile, maxLogFileSize, maxLogBackupFiles, logPattern, delimiter, settings);
        this.datePattern = (String)this.firstNonNull(datePattern, (String)this.getSettings().get("datePattern"), DATE_PATTERN);
    }

    @Override
    protected RollingPolicy buildRollingPolicy(FileAppender<?> appender, String fileStr) {
        SizeAndTimeBasedRollingPolicy rollingPolicy = new SizeAndTimeBasedRollingPolicy();
        rollingPolicy.setParent(appender);
        rollingPolicy.setContext((Context)loggerContext);
        if (this.getMaxLogFileSize() == null) {
            rollingPolicy.setFileNamePattern(fileStr + "%d{" + this.datePattern + "}");
        } else {
            rollingPolicy.setMaxFileSize(FileSize.valueOf((String)this.getMaxLogFileSize()));
            rollingPolicy.setFileNamePattern(fileStr + "%d{" + this.datePattern + "}.%i");
        }
        rollingPolicy.setMaxHistory(this.getMaxLogBackupFiles().intValue());
        rollingPolicy.start();
        return rollingPolicy;
    }

    @Override
    protected TriggeringPolicy buildTriggeringPolicy() {
        return null;
    }

    @Override
    protected String buildLoggerName() {
        return "DailyKeyOutWriter" + ((Object)((Object)this)).hashCode();
    }

    public String getDatePattern() {
        return this.datePattern;
    }
}

