/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.GraphiteWriter2;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KeyOutWriter
extends BaseOutputWriter {
    protected static final LoggerContext loggerContext = new LoggerContext();
    protected static final String SETTING_MAX_LOG_FILE_SIZE = "maxLogFileSize";
    protected static final String SETTING_MAX_BACK_FILES = "maxLogBackupFiles";
    protected static final String SETTING_LOG_PATTERN = "logPattern";
    protected static final String SETTING_DELIMITER = "delimiter";
    protected static final int LOG_IO_BUFFER_SIZE_BYTES = 1024;
    protected static final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    protected static final int MAX_LOG_BACKUP_FILES = 200;
    protected static final String MAX_LOG_FILE_SIZE = "10MB";
    protected static final String DEFAULT_LOG_PATTERN = "%msg%n";
    protected static final String DEFAULT_DELIMITER = "\t";
    private LogWriter logwriter;
    private final String outputFile;
    private final String maxLogFileSize;
    private final int maxLogBackupFiles;
    private final String delimiter;
    private final String logPattern;
    private final GraphiteWriter2 graphiteWriter;

    @JsonCreator
    public KeyOutWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="outputFile") String outputFile, @JsonProperty(value="maxLogFileSize") String maxLogFileSize, @JsonProperty(value="maxLogBackupFiles") Integer maxLogBackupFiles, @JsonProperty(value="logPattern") String logPattern, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.outputFile = (String)MoreObjects.firstNonNull((Object)outputFile, (Object)((String)this.getSettings().get("outputFile")));
        this.maxLogFileSize = (String)this.firstNonNull(maxLogFileSize, (String)this.getSettings().get(SETTING_MAX_LOG_FILE_SIZE), MAX_LOG_FILE_SIZE);
        this.maxLogBackupFiles = (Integer)this.firstNonNull(maxLogBackupFiles, (Integer)this.getSettings().get(SETTING_MAX_BACK_FILES), 200);
        this.logPattern = (String)this.firstNonNull(logPattern, (String)this.getSettings().get(SETTING_LOG_PATTERN), DEFAULT_LOG_PATTERN);
        this.delimiter = (String)this.firstNonNull(delimiter, (String)this.getSettings().get(SETTING_DELIMITER), DEFAULT_DELIMITER);
        this.graphiteWriter = new GraphiteWriter2(typeNames, null);
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        Logger logger;
        if (loggers.containsKey(this.outputFile)) {
            logger = this.getLogger(this.outputFile);
        } else {
            try {
                logger = this.buildLogger(this.outputFile);
                loggers.put(this.outputFile, logger);
            }
            catch (IOException e) {
                throw new ValidationException("Failed to setup logback", query, (Throwable)e);
            }
        }
        this.logwriter = new LogWriter(logger, this.delimiter);
    }

    @VisibleForTesting
    Logger getLogger(String outputFile) {
        return loggers.get(outputFile);
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.graphiteWriter.write((Writer)this.logwriter, server, query, results);
    }

    protected Logger buildLogger(String fileStr) throws IOException {
        String loggerName = this.buildLoggerName();
        Appender appender = this.buildAppender(loggerName, fileStr);
        Logger logger = loggerContext.getLogger(loggerName);
        logger.addAppender(appender);
        logger.setLevel(Level.INFO);
        logger.setAdditive(false);
        return logger;
    }

    protected String buildLoggerName() {
        return "KeyOutWriter" + ((Object)((Object)this)).hashCode();
    }

    protected Encoder buildEncoder() {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern(this.logPattern);
        encoder.start();
        return encoder;
    }

    protected RollingPolicy buildRollingPolicy(FileAppender<?> appender, String fileStr) {
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setParent(appender);
        rollingPolicy.setContext((Context)loggerContext);
        rollingPolicy.setMinIndex(1);
        rollingPolicy.setMaxIndex(this.maxLogBackupFiles);
        rollingPolicy.setFileNamePattern(fileStr + ".%i");
        rollingPolicy.start();
        return rollingPolicy;
    }

    protected TriggeringPolicy buildTriggeringPolicy() {
        SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
        triggeringPolicy.setContext((Context)loggerContext);
        triggeringPolicy.setMaxFileSize(FileSize.valueOf((String)this.maxLogFileSize));
        triggeringPolicy.start();
        return triggeringPolicy;
    }

    protected Appender buildAppender(String loggerName, String fileStr) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setName(loggerName + "RollingFile");
        appender.setContext((Context)loggerContext);
        appender.setImmediateFlush(true);
        appender.setBufferSize(new FileSize(1024L));
        appender.setFile(fileStr);
        appender.setEncoder(this.buildEncoder());
        TriggeringPolicy triggeringPolicy = this.buildTriggeringPolicy();
        if (triggeringPolicy != null) {
            appender.setTriggeringPolicy(triggeringPolicy);
        }
        appender.setRollingPolicy(this.buildRollingPolicy((FileAppender<?>)appender, fileStr));
        appender.start();
        return appender;
    }

    public void close() {
        for (Logger logger : loggers.values()) {
            logger.detachAndStopAllAppenders();
        }
        loggers.clear();
    }

    public String getMaxLogFileSize() {
        return this.maxLogFileSize;
    }

    public Integer getMaxLogBackupFiles() {
        return this.maxLogBackupFiles;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public static class LogWriter
    extends Writer {
        private final Logger logger;
        private final String delimiter;

        public LogWriter(Logger logger, String delimiter) {
            this.logger = logger;
            this.delimiter = delimiter;
        }

        @Override
        public void write(String str) throws IOException {
            this.logger.info(str.replace("\n", "").replace(" ", this.delimiter));
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.logger.info(String.copyValueOf(cbuf, off, len).replace("\n", "").replace(" ", this.delimiter));
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

