/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.test;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPEchoServer
extends ExternalResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Thread thread = null;
    private volatile ServerSocket server;
    private final Object startSynchro = new Object();

    public void before() {
        this.start();
    }

    protected void after() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.thread != null) {
            throw new IllegalStateException("Server already started");
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Closer closer = Closer.create();
                try {
                    try {
                        try {
                            TCPEchoServer.this.server = (ServerSocket)closer.register((Closeable)new ServerSocket(0));
                            while (true) {
                                TCPEchoServer.this.processRequests(TCPEchoServer.this.server);
                            }
                        }
                        catch (Throwable t) {
                            throw closer.rethrow(t);
                        }
                    }
                    catch (Throwable throwable) {
                        closer.close();
                        TCPEchoServer.this.server = null;
                        throw throwable;
                    }
                }
                catch (IOException ioe) {
                    TCPEchoServer.this.log.error("Exception in TCP echo server", (Throwable)ioe);
                    return;
                }
            }
        });
        this.thread.start();
        try {
            Object object = this.startSynchro;
            synchronized (object) {
                this.startSynchro.wait(1000L);
            }
        }
        catch (InterruptedException interrupted) {
            this.log.error("TCP Echo server seems to take too long to start", (Throwable)interrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequests(ServerSocket server) throws IOException {
        Closer closer = Closer.create();
        try {
            String line;
            Socket socket = server.accept();
            Object object = this.startSynchro;
            synchronized (object) {
                this.startSynchro.notifyAll();
            }
            BufferedReader in = (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader(socket.getInputStream(), Charsets.UTF_8)));
            PrintWriter out = (PrintWriter)closer.register((Closeable)new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), Charsets.UTF_8)));
            while ((line = in.readLine()) != null) {
                out.print(line);
            }
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    public void stop() {
        Preconditions.checkState((this.thread != null ? 1 : 0) != 0, (Object)"Server not started");
        this.thread.interrupt();
    }

    public InetSocketAddress getLocalSocketAddress() {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"Server not started");
        return new InetSocketAddress("localhost", this.server.getLocalPort());
    }
}

