/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.test;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpLoggingServer
extends ExternalResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Nullable
    private Thread thread = null;
    private final Object startSynchro = new Object();
    private volatile DatagramSocket socket;
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();
    private final Charset charset;

    public UdpLoggingServer(@Nonnull Charset charset) {
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Preconditions.checkState((this.thread == null ? 1 : 0) != 0, (Object)"UDP Server already started");
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Closer closer = Closer.create();
                    try {
                        try {
                            UdpLoggingServer.this.socket = (DatagramSocket)closer.register((Closeable)new DatagramSocket());
                            while (true) {
                                UdpLoggingServer.this.processRequests(UdpLoggingServer.this.socket);
                            }
                        }
                        catch (Throwable t) {
                            throw closer.rethrow(t);
                        }
                    }
                    catch (Throwable throwable) {
                        closer.close();
                        UdpLoggingServer.this.socket = null;
                        throw throwable;
                    }
                }
                catch (IOException ioe) {
                    UdpLoggingServer.this.log.error("Exception in TCP echo server", (Throwable)ioe);
                    return;
                }
            }
        });
        this.thread.start();
        try {
            Object object = this.startSynchro;
            synchronized (object) {
                this.startSynchro.wait(1000L);
            }
        }
        catch (InterruptedException interrupted) {
            this.log.error("UDP server seems to take too long to start", (Throwable)interrupted);
        }
    }

    private void processRequests(DatagramSocket socket) throws IOException {
        byte[] buffer = new byte[1024];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        socket.receive(packet);
        String messageReceived = new String(packet.getData(), 0, packet.getLength(), this.charset);
        this.log.debug("Message received: {}", (Object)messageReceived);
        this.receivedMessages.add(messageReceived);
    }

    public boolean messageReceived(@Nonnull String message) {
        return this.receivedMessages.contains(message);
    }

    private void stop() {
        Preconditions.checkState((this.thread != null ? 1 : 0) != 0, (Object)"UDP server not started");
        this.thread.interrupt();
    }

    @Nonnull
    public InetSocketAddress getLocalSocketAddress() {
        Preconditions.checkState((this.socket != null ? 1 : 0) != 0, (Object)"Server not started");
        return new InetSocketAddress("localhost", this.socket.getLocalPort());
    }

    protected void before() throws Throwable {
        this.start();
    }

    protected void after() {
        this.stop();
    }
}

