/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.test;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.junit.rules.ExternalResource;

public class OutputCapture
extends ExternalResource {
    private PrintStream originalOut;
    private PrintStream originalErr;
    private ByteArrayOutputStream out;
    private ByteArrayOutputStream err;

    protected void before() throws Throwable {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.out = new ByteArrayOutputStream();
        System.setOut(new PrintStream((OutputStream)this.out, false, Charsets.UTF_8.toString()));
        this.err = new ByteArrayOutputStream();
        System.setErr(new PrintStream((OutputStream)this.err, false, Charsets.UTF_8.toString()));
    }

    protected void after() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    public Callable<Boolean> stdoutHasLineContaining(String content) {
        return this.hasLineContaining(this.out, content);
    }

    public Callable<Boolean> stderrHasLineContaining(String content) {
        return this.hasLineContaining(this.err, content);
    }

    private Callable<Boolean> hasLineContaining(final ByteArrayOutputStream out, final String content) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return out.toString(Charsets.UTF_8.toString()).contains(content);
            }
        };
    }
}

