/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.test;

import java.io.Closeable;

public class ResetableSystemProperty
implements Closeable {
    private final String key;
    private final String oldValue;

    private ResetableSystemProperty(String key, String newValue, String oldValue) {
        this.key = key;
        this.oldValue = oldValue;
        System.setProperty(key, newValue);
    }

    @Override
    public void close() {
        if (this.oldValue != null) {
            System.setProperty(this.key, this.oldValue);
        } else {
            System.clearProperty(this.key);
        }
    }

    public static ResetableSystemProperty setSystemProperty(String key, String value) {
        return new ResetableSystemProperty(key, value, System.getProperty(key));
    }
}

