/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.test;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.junit.rules.ExternalResource;

public class ExternalApp
extends ExternalResource {
    private final String[] appArgs;
    private Process app;
    private final Class<?> appClass;
    private final Properties properties = new Properties();
    private File outputFile;

    public ExternalApp(Class<?> appClass, String ... args) {
        this.appClass = appClass;
        this.appArgs = args;
    }

    public ExternalApp enableJmx(int jmxPort) {
        this.properties.put("com.sun.management.jmxremote.authenticate", "false");
        this.properties.put("com.sun.management.jmxremote.ssl", "false");
        this.properties.put("com.sun.management.jmxremote.port", Integer.toString(jmxPort));
        return this;
    }

    public ExternalApp redirectOutputToFile(File outputFile) {
        this.outputFile = outputFile;
        return this;
    }

    private String filePath(String filename) {
        URL fileUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(filename);
        try {
            return new File(fileUrl.toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            return fileUrl.getPath();
        }
    }

    public ExternalApp enableSsl(String keyStore, String keyStorePassword) {
        if (this.properties.get("com.sun.management.jmxremote.port") != null) {
            this.properties.put("com.sun.management.jmxremote.ssl", "true");
            this.properties.put("com.sun.management.jmxremote.registry.ssl", "true");
        }
        String keyStorePath = this.filePath(keyStore);
        this.properties.put("javax.net.ssl.keyStore", keyStorePath);
        this.properties.put("javax.net.ssl.keyStorePassword", keyStorePassword);
        this.properties.put("javax.net.ssl.trustStore", keyStorePath);
        this.properties.put("javax.net.ssl.trustStorePassword", keyStorePassword);
        return this;
    }

    @IgnoreJRERequirement
    protected void before() throws Throwable {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("java", "-cp", this.getCurrentClasspath()));
        for (Map.Entry<Object, Object> property : this.properties.entrySet()) {
            command.add("-D" + property.getKey() + "=" + property.getValue());
        }
        command.add(this.appClass.getCanonicalName());
        if (this.appArgs != null) {
            command.addAll(Arrays.asList(this.appArgs));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command).inheritIO();
        if (this.outputFile != null) {
            processBuilder.redirectOutput(this.outputFile);
        }
        this.app = processBuilder.start();
    }

    public InputStream getInputStream() {
        return this.app.getInputStream();
    }

    private String getCurrentClasspath() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)cl).getURLs();
        return Joiner.on((String)File.pathSeparator).join((Iterable)FluentIterable.from(Arrays.asList(urls)).transform((Function)new Function<URL, String>(){

            @Nullable
            public String apply(URL input) {
                try {
                    return new File(input.toURI()).getPath();
                }
                catch (URISyntaxException e) {
                    return input.getPath();
                }
            }
        }));
    }

    protected void after() {
        this.app.destroy();
    }
}

