/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.test;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPEchoServer
extends ExternalResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Thread thread = null;
    private volatile ServerSocket server;
    private final Object startSynchro = new Object();
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();
    private final AtomicInteger connectionsAccepted = new AtomicInteger();

    public void before() {
        this.start();
    }

    protected void after() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Preconditions.checkState((this.thread == null ? 1 : 0) != 0, (Object)"Server already started");
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Closer closer = Closer.create();
                    try {
                        try {
                            TCPEchoServer.this.server = (ServerSocket)closer.register((Closeable)new ServerSocket(0));
                            while (true) {
                                TCPEchoServer.this.processRequests(TCPEchoServer.this.server);
                            }
                        }
                        catch (Throwable t) {
                            throw closer.rethrow(t);
                        }
                    }
                    catch (Throwable throwable) {
                        closer.close();
                        TCPEchoServer.this.server = null;
                        throw throwable;
                    }
                }
                catch (IOException ioe) {
                    TCPEchoServer.this.log.error("Exception in TCP echo server", (Throwable)ioe);
                    return;
                }
            }
        });
        this.thread.start();
        try {
            Object object = this.startSynchro;
            synchronized (object) {
                this.startSynchro.wait(1000L);
            }
        }
        catch (InterruptedException interrupted) {
            this.log.error("TCP Echo server seems to take too long to start", (Throwable)interrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequests(ServerSocket server) throws IOException {
        Socket socket = server.accept();
        this.connectionsAccepted.incrementAndGet();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), Charsets.UTF_8));
             PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), Charsets.UTF_8));){
            String line;
            Object object = this.startSynchro;
            synchronized (object) {
                this.startSynchro.notifyAll();
            }
            while ((line = in.readLine()) != null) {
                this.receivedMessages.add(line);
                out.print(line);
            }
        }
    }

    public void stop() {
        Preconditions.checkState((this.thread != null ? 1 : 0) != 0, (Object)"Server not started");
        this.thread.interrupt();
    }

    public boolean messageReceived(@Nonnull String message) {
        return this.receivedMessages.contains(message);
    }

    public InetSocketAddress getLocalSocketAddress() {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"Server not started");
        return new InetSocketAddress("localhost", this.server.getLocalPort());
    }

    public int getConnectionsAccepted() {
        return this.connectionsAccepted.get();
    }
}

