/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.test;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpLoggingServer
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpLoggingServer.class);
    private final Charset charset;
    private ProcessRequestLoop loop;

    public UdpLoggingServer(@Nonnull Charset charset) {
        this.charset = charset;
    }

    protected void before() throws Throwable {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0, (Object)"UDP Server already started");
        this.loop = new ProcessRequestLoop(this.charset);
        Thread thread = new Thread(this.loop);
        thread.start();
    }

    public boolean isRunning() {
        return this.loop != null && this.loop.isRunning();
    }

    public boolean messageReceived(@Nonnull String message) {
        Preconditions.checkState((this.loop != null ? 1 : 0) != 0, (Object)"UDP server not started");
        return this.loop.messageReceived(message);
    }

    @Nonnull
    public InetSocketAddress getLocalSocketAddress() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"Server not started");
        return new InetSocketAddress("localhost", this.loop.getPort());
    }

    protected void after() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"UDP server not started");
        this.loop.stop();
    }

    private static class ProcessRequestLoop
    implements Runnable {
        private final DatagramSocket socket;
        private final Charset charset;
        private final AtomicBoolean running = new AtomicBoolean();
        private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();

        private ProcessRequestLoop(Charset charset) throws SocketException {
            this.socket = new DatagramSocket();
            this.running.set(true);
            this.charset = charset;
        }

        public int getPort() {
            return this.socket.getLocalPort();
        }

        @Override
        public void run() {
            LOGGER.info("UDP server started on port {}", (Object)this.getPort());
            try {
                while (this.isRunning()) {
                    this.processRequests();
                }
            }
            catch (IOException ioe) {
                LOGGER.error("Exception in UDP server", (Throwable)ioe);
            }
            finally {
                this.running.set(false);
            }
        }

        private boolean isRunning() {
            return this.running.get();
        }

        private void processRequests() throws IOException {
            byte[] buffer = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            this.socket.receive(packet);
            String messageReceived = new String(packet.getData(), 0, packet.getLength(), this.charset);
            LOGGER.debug("Message received: {}", (Object)messageReceived);
            this.receivedMessages.add(messageReceived);
        }

        private boolean messageReceived(@Nonnull String message) {
            return this.receivedMessages.contains(message);
        }

        private void stop() {
            this.running.set(false);
        }
    }
}

