/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.util;

import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public abstract class SignalInterceptor {
    protected SignalInterceptor() {
    }

    protected void register(String signame) throws SignalInterceptorException {
        try {
            new SignalInterceptorHelper(signame, this);
        }
        catch (Throwable e) {
            throw new SignalInterceptorException(signame, e);
        }
    }

    protected boolean registerQuietly(String signame) {
        try {
            this.register(signame);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    protected abstract boolean handle(String var1);

    private static class SignalInterceptorException
    extends Exception {
        SignalInterceptorException(String signal, Throwable cause) {
            super("Unable to register for SIG" + signal, cause);
        }
    }

    @IgnoreJRERequirement
    private static class SignalInterceptorHelper
    implements SignalHandler {
        private final SignalHandler oldHandler;
        private final SignalInterceptor interceptor;

        @IgnoreJRERequirement
        SignalInterceptorHelper(String signame, SignalInterceptor interceptor) {
            this.interceptor = interceptor;
            Signal signal = new Signal(signame);
            this.oldHandler = Signal.handle(signal, this);
        }

        @Override
        @IgnoreJRERequirement
        public void handle(Signal sig) {
            if (this.interceptor.handle(sig.getName()) && this.oldHandler != null) {
                this.oldHandler.handle(sig);
            }
        }
    }
}

