/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.util;

import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.util.WatchedCallback;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.FileSystems;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.Paths;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchDir
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(WatchDir.class);
    private final WatchService watchService;
    private final WatchedCallback watched;
    private final Map<WatchKey, Path> keys;

    public WatchDir(File dir, WatchedCallback watched) throws IOException {
        this.watched = watched;
        this.keys = Maps.newHashMap();
        this.watchService = FileSystems.getDefault().newWatchService();
        Path watchedPath = Paths.get((String)dir.getAbsolutePath());
        WatchKey signalledKey = watchedPath.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY});
        this.keys.put(signalledKey, watchedPath);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block9: {
            block5: while (true) {
                try {
                    signalledKey = this.watchService.take();
                }
                catch (InterruptedException ix) {
                    continue;
                }
                catch (ClosedWatchServiceException cwse) {
                    WatchDir.log.debug("Watch service closed, terminating.");
                    break block9;
                }
                list = signalledKey.pollEvents();
                signalledKey.reset();
                dir = this.keys.get(signalledKey);
                i$ = list.iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block5;
                    e = (WatchEvent)i$.next();
                    if (e.kind() == StandardWatchEventKind.ENTRY_CREATE) {
                        context = (Path)e.context();
                        fullPath = dir.resolve(context);
                        this.watched.fileAdded(new File(fullPath.toString()));
                        continue;
                    }
                    if (e.kind() == StandardWatchEventKind.ENTRY_DELETE) {
                        context = (Path)e.context();
                        fullPath = dir.resolve(context);
                        this.watched.fileDeleted(new File(fullPath.toString()));
                        continue;
                    }
                    if (e.kind() != StandardWatchEventKind.ENTRY_MODIFY) continue;
                    context = (Path)e.context();
                    fullPath = dir.resolve(context);
                    this.watched.fileModified(new File(fullPath.toString()));
                }
                break;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stopService() throws IOException {
        this.watchService.close();
    }
}

