/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.classloader;

import com.googlecode.jmxtrans.classloader.JarLoadingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassLoaderEnricher {
    public void add(File file) throws MalformedURLException, FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("Additional jar [" + file.getAbsolutePath() + "] does not exist");
        }
        this.add(file.toURI().toURL());
    }

    public void add(URL url) {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysClass = URLClassLoader.class;
        try {
            Method method = sysClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysLoader, url);
        }
        catch (InvocationTargetException e) {
            throw new JarLoadingException(e);
        }
        catch (NoSuchMethodException e) {
            throw new JarLoadingException(e);
        }
        catch (IllegalAccessException e) {
            throw new JarLoadingException(e);
        }
    }
}

