/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.util;

import com.googlecode.jmxtrans.util.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ManualClock
implements Clock {
    private volatile AtomicLong currentTimeMillis = new AtomicLong(0L);

    public ManualClock() {
        this.setTime(0L, TimeUnit.MILLISECONDS);
    }

    public ManualClock(long time, TimeUnit unit) {
        this.setTime(time, unit);
    }

    @Override
    public long currentTimeMillis() {
        return this.currentTimeMillis.get();
    }

    public void setTime(long time, TimeUnit unit) {
        this.currentTimeMillis.set(TimeUnit.MILLISECONDS.convert(time, unit));
    }

    public void waitFor(long duration, TimeUnit unit) {
        this.currentTimeMillis.addAndGet(TimeUnit.MILLISECONDS.convert(duration, unit));
    }
}

