/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.util;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public class OnlyOnceLogger {
    public static final int DEFAULT_HISTORY_SIZE = 32768;
    @Nonnull
    private final Logger logger;
    private final Set<LogEntry> alreadyLogged = new HashSet<LogEntry>();
    private final int maxHistorySize;

    public OnlyOnceLogger(Logger logger) {
        this(logger, 32768);
    }

    public OnlyOnceLogger(Logger logger, int maxHistorySize) {
        this.logger = logger;
        this.maxHistorySize = maxHistorySize;
    }

    public void infoOnce(String format, Object ... arguments) {
        if (this.maxHistorySizeReached()) {
            return;
        }
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        LogEntry logEntry = new LogEntry(format, arguments);
        if (this.shouldLog(logEntry)) {
            this.logger.info(format, arguments);
        }
    }

    private synchronized boolean maxHistorySizeReached() {
        return this.alreadyLogged.size() >= this.maxHistorySize;
    }

    private synchronized boolean shouldLog(LogEntry logEntry) {
        if (this.alreadyLogged.contains(logEntry)) {
            return false;
        }
        this.alreadyLogged.add(logEntry);
        return true;
    }

    private static final class LogEntry {
        private final String format;
        private final List<Object> arguments;

        private LogEntry(String format, Object[] arguments) {
            this.format = format;
            this.arguments = ImmutableList.copyOf((Object[])arguments);
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogEntry)) {
                return false;
            }
            LogEntry other = (LogEntry)o;
            String this$format = this.format;
            String other$format = other.format;
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            List<Object> this$arguments = this.arguments;
            List<Object> other$arguments = other.arguments;
            return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $format = this.format;
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            List<Object> $arguments = this.arguments;
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            return result;
        }
    }
}

