/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.webapp;

import com.googlecode.jmxtrans.JmxTransformer;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.cli.JmxTransConfigurationFactory;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.webapp.JmxTransContextException;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTransContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(JmxTransContextListener.class);
    private JmxTransformer jmxTransformer;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            JmxTransConfiguration configuration = this.loadConfiguration(servletContextEvent);
            this.jmxTransformer = JmxTransformer.create((JmxTransConfiguration)configuration);
            this.jmxTransformer.start();
            log.info("JMXTrans is running");
        }
        catch (LifecycleException | IOException e) {
            throw new JmxTransContextException("Failed to initialize JMXTrans context", e);
        }
    }

    private JmxTransConfiguration loadConfiguration(ServletContextEvent servletContextEvent) throws IOException {
        String configFile = System.getProperty("jmxtrans.config.file");
        if (configFile == null) {
            configFile = servletContextEvent.getServletContext().getInitParameter("configFile");
        }
        return JmxTransConfigurationFactory.fromProperties((File)(configFile == null ? null : new File(configFile)));
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.jmxTransformer != null) {
            try {
                log.info("Stopping JMXTrans");
                this.jmxTransformer.stop();
            }
            catch (LifecycleException e) {
                throw new JmxTransContextException("Failed to destroy JMXTrans context", (Throwable)e);
            }
        }
    }
}

