/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.kotlin.utils.mapper;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.InternalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jobrunr.kotlin.serialization.utils.KotlinxSerializationUtilsKt;
import org.jobrunr.kotlin.utils.mapper.KotlinxSerializationModuleKt;
import org.jobrunr.utils.mapper.JobParameterJsonMapperException;
import org.jobrunr.utils.mapper.JsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSerializationApi
@InternalSerializationApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J1\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J!\u0010\u001c\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jobrunr/kotlin/utils/mapper/KotlinxSerializationJsonMapper;", "Lorg/jobrunr/utils/mapper/JsonMapper;", "json", "Lkotlinx/serialization/json/Json;", "<init>", "(Lkotlinx/serialization/json/Json;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(Lkotlinx/serialization/modules/SerializersModule;)V", "()V", "serialize", "", "obj", "", "", "outputStream", "Ljava/io/OutputStream;", "deserialize", "T", "serializedObjectAsString", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "noSerializerFound", "Ljava/lang/Exception;", "Lkotlin/Exception;", "kClass", "Lkotlin/reflect/KClass;", "rethrowSerializationException", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "jobrunr-kotlin-22-support"})
public final class KotlinxSerializationJsonMapper
implements JsonMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Json json;
    private static final Logger LOGGER = LoggerFactory.getLogger(KotlinxSerializationJsonMapper.class);

    public KotlinxSerializationJsonMapper(@NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
    }

    public KotlinxSerializationJsonMapper(@NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this(JsonKt.Json$default(null, arg_0 -> KotlinxSerializationJsonMapper._init_$lambda$0(serializersModule, arg_0), (int)1, null));
    }

    public KotlinxSerializationJsonMapper() {
        this(KotlinxSerializationModuleKt.getJobRunrSerializersModule());
    }

    @Nullable
    public String serialize(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return (String)this.rethrowSerializationException(() -> KotlinxSerializationJsonMapper.serialize$lambda$1(obj, this));
    }

    public void serialize(@NotNull OutputStream outputStream, @NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.rethrowSerializationException(() -> KotlinxSerializationJsonMapper.serialize$lambda$3(obj, outputStream, this));
    }

    @Nullable
    public <T> T deserialize(@Nullable String serializedObjectAsString, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.rethrowSerializationException(() -> KotlinxSerializationJsonMapper.deserialize$lambda$5(serializedObjectAsString, this, clazz));
    }

    private final Exception noSerializerFound(KClass<?> kClass) {
        return (Exception)new JobParameterJsonMapperException("No serializer for " + kClass.getQualifiedName());
    }

    private final <T> T rethrowSerializationException(Function0<? extends T> block) {
        Object object;
        try {
            object = block.invoke();
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred during serialization - please report this!", (Throwable)e);
            throw e instanceof SerializationException ? (Throwable)new JobParameterJsonMapperException(e.getMessage(), (Throwable)e) : (Throwable)e;
        }
        return (T)object;
    }

    private static final Unit _init_$lambda$0(SerializersModule $serializersModule, JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setEncodeDefaults(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setClassDiscriminator("@class");
        $this$Json.setSerializersModule(SerializersModuleKt.plus((SerializersModule)$serializersModule, (SerializersModule)KotlinxSerializationModuleKt.getJobRunrSerializersModule()));
        return Unit.INSTANCE;
    }

    private static final <T> String serialize$lambda$1$encode(KotlinxSerializationJsonMapper this$0, Object obj) {
        Json json = this$0.json;
        SerializationStrategy serializationStrategy = (SerializationStrategy)KotlinxSerializationUtilsKt.serializer(this$0.json.getSerializersModule(), Reflection.getOrCreateKotlinClass(obj.getClass()));
        if (serializationStrategy == null) {
            throw this$0.noSerializerFound(Reflection.getOrCreateKotlinClass(obj.getClass()));
        }
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type T of org.jobrunr.kotlin.utils.mapper.KotlinxSerializationJsonMapper.serialize.<anonymous>.encode");
        return json.encodeToString(serializationStrategy, obj);
    }

    private static final String serialize$lambda$1(Object $obj, KotlinxSerializationJsonMapper this$0) {
        return KotlinxSerializationJsonMapper.serialize$lambda$1$encode(this$0, $obj);
    }

    private static final <T> void serialize$lambda$3$encode$2(KotlinxSerializationJsonMapper this$0, Object obj, OutputStream outputStream) {
        Json json = this$0.json;
        SerializationStrategy serializationStrategy = (SerializationStrategy)KotlinxSerializationUtilsKt.serializer(this$0.json.getSerializersModule(), Reflection.getOrCreateKotlinClass(obj.getClass()));
        if (serializationStrategy == null) {
            throw this$0.noSerializerFound(Reflection.getOrCreateKotlinClass(obj.getClass()));
        }
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type T of org.jobrunr.kotlin.utils.mapper.KotlinxSerializationJsonMapper.serialize.<anonymous>.encode");
        JvmStreamsKt.encodeToStream((Json)json, (SerializationStrategy)serializationStrategy, (Object)obj, (OutputStream)outputStream);
    }

    private static final Unit serialize$lambda$3(Object $obj, OutputStream $outputStream, KotlinxSerializationJsonMapper this$0) {
        KotlinxSerializationJsonMapper.serialize$lambda$3$encode$2(this$0, $obj, $outputStream);
        return Unit.INSTANCE;
    }

    private static final Object deserialize$lambda$5(String $serializedObjectAsString, KotlinxSerializationJsonMapper this$0, Class $clazz) {
        Object object;
        String string = $serializedObjectAsString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            KSerializer kSerializer = KotlinxSerializationUtilsKt.serializer(this$0.json.getSerializersModule(), JvmClassMappingKt.getKotlinClass((Class)$clazz));
            if (kSerializer == null) {
                throw this$0.noSerializerFound(JvmClassMappingKt.getKotlinClass((Class)$clazz));
            }
            object = this$0.json.decodeFromString((DeserializationStrategy)kSerializer, $serializedObjectAsString);
        } else {
            object = null;
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jobrunr/kotlin/utils/mapper/KotlinxSerializationJsonMapper$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jobrunr-kotlin-22-support"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

