/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.micronaut.autoconfigure;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.bind.annotation.Bindable;
import java.time.Duration;
import java.util.Optional;
import javax.validation.constraints.NotNull;

@Context
@ConfigurationProperties(value="jobrunr")
public interface JobRunrConfiguration {
    @NotNull
    public DatabaseConfiguration getDatabase();

    @NotNull
    public JobSchedulerConfiguration getJobScheduler();

    @NotNull
    public BackgroundJobServerConfiguration getBackgroundJobServer();

    @NotNull
    public DashboardConfiguration getDashboard();

    @ConfigurationProperties(value="health")
    public static interface Health {
        @Bindable(defaultValue="false")
        public boolean isEnabled();
    }

    @ConfigurationProperties(value="dashboard")
    public static interface DashboardConfiguration {
        @Bindable(defaultValue="false")
        public boolean isEnabled();

        public Optional<Integer> getPort();

        public Optional<String> getUsername();

        public Optional<String> getPassword();
    }

    @ConfigurationProperties(value="backgroundJobServer")
    public static interface BackgroundJobServerConfiguration {
        @Bindable(defaultValue="false")
        public boolean isEnabled();

        public Optional<Integer> getWorkerCount();

        public Optional<Integer> getPollIntervalInSeconds();

        public Optional<Duration> getDeleteSucceededJobsAfter();

        public Optional<Duration> getPermanentlyDeleteDeletedJobsAfter();
    }

    @ConfigurationProperties(value="jobScheduler")
    public static interface JobSchedulerConfiguration {
        @Bindable(defaultValue="true")
        public boolean isEnabled();

        public Optional<String> getJobDetailsGenerator();
    }

    @ConfigurationProperties(value="database")
    public static interface DatabaseConfiguration {
        @Bindable(defaultValue="false")
        public boolean isSkipCreate();

        public Optional<String> getDatabaseName();

        public Optional<String> getTablePrefix();

        public Optional<String> getDatasource();
    }
}

