/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.micronaut.autoconfigure;

import com.mongodb.client.MongoClient;
import io.lettuce.core.RedisClient;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import javax.sql.DataSource;
import org.elasticsearch.client.RestHighLevelClient;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.jobs.details.CachingJobDetailsGenerator;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.micronaut.autoconfigure.JobRunrConfiguration;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.storage.InMemoryStorageProvider;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchStorageProvider;
import org.jobrunr.storage.nosql.mongo.MongoDBStorageProvider;
import org.jobrunr.storage.nosql.redis.LettuceRedisStorageProvider;
import org.jobrunr.storage.sql.common.SqlStorageProviderFactory;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.jobrunr.utils.reflection.ReflectionUtils;

@Factory
public class JobRunrFactory {
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private JobRunrConfiguration configuration;

    @Singleton
    @Requires(property="jobrunr.job-scheduler.enabled", value="true")
    public JobScheduler jobScheduler(StorageProvider storageProvider) {
        JobDetailsGenerator jobDetailsGenerator = (JobDetailsGenerator)ReflectionUtils.newInstance((String)this.configuration.getJobScheduler().getJobDetailsGenerator().orElse(CachingJobDetailsGenerator.class.getName()), (Object[])new Object[0]);
        return new JobScheduler(storageProvider, jobDetailsGenerator, Collections.emptyList());
    }

    @Singleton
    @Requires(property="jobrunr.job-scheduler.enabled", value="true")
    public JobRequestScheduler jobRequestScheduler(StorageProvider storageProvider) {
        return new JobRequestScheduler(storageProvider, Collections.emptyList());
    }

    @Singleton
    @Requires(property="jobrunr.background-job-server.enabled", value="true")
    public BackgroundJobServerConfiguration backgroundJobServerConfiguration() {
        BackgroundJobServerConfiguration backgroundJobServerConfiguration = BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration();
        this.configuration.getBackgroundJobServer().getPollIntervalInSeconds().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPollIntervalInSeconds(arg_0));
        this.configuration.getBackgroundJobServer().getWorkerCount().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andWorkerCount(arg_0));
        this.configuration.getBackgroundJobServer().getDeleteSucceededJobsAfter().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andDeleteSucceededJobsAfter(arg_0));
        this.configuration.getBackgroundJobServer().getPermanentlyDeleteDeletedJobsAfter().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPermanentlyDeleteDeletedJobsAfter(arg_0));
        return backgroundJobServerConfiguration;
    }

    @Singleton
    @Requires(property="jobrunr.background-job-server.enabled", value="true")
    public BackgroundJobServer backgroundJobServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobActivator jobActivator, BackgroundJobServerConfiguration backgroundJobServerConfiguration) {
        return new BackgroundJobServer(storageProvider, jobRunrJsonMapper, jobActivator, backgroundJobServerConfiguration);
    }

    @Singleton
    @Requires(property="jobrunr.dashboard.enabled", value="true")
    public JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration() {
        JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration = JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration();
        this.configuration.getDashboard().getPort().ifPresent(arg_0 -> ((JobRunrDashboardWebServerConfiguration)dashboardWebServerConfiguration).andPort(arg_0));
        if (this.configuration.getDashboard().getUsername().isPresent() && this.configuration.getDashboard().getPassword().isPresent()) {
            dashboardWebServerConfiguration.andBasicAuthentication(this.configuration.getDashboard().getUsername().get(), this.configuration.getDashboard().getPassword().get());
        }
        return dashboardWebServerConfiguration;
    }

    @Singleton
    @Requires(property="jobrunr.dashboard.enabled", value="true")
    public JobRunrDashboardWebServer dashboardWebServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration) {
        return new JobRunrDashboardWebServer(storageProvider, jobRunrJsonMapper, dashboardWebServerConfiguration);
    }

    @Singleton
    public JobActivator jobActivator() {
        return new JobActivator(){

            public <T> T activateJob(Class<T> aClass) {
                return (T)JobRunrFactory.this.applicationContext.getBean(aClass);
            }
        };
    }

    @Singleton
    public JobMapper jobMapper(JsonMapper jobRunrJsonMapper) {
        return new JobMapper(jobRunrJsonMapper);
    }

    @Singleton
    public JsonMapper jobRunrJsonMapper() {
        return new JacksonJsonMapper();
    }

    @Singleton
    public StorageProvider storageProvider(JobMapper jobMapper) {
        InMemoryStorageProvider storageProvider = new InMemoryStorageProvider();
        storageProvider.setJobMapper(jobMapper);
        return storageProvider;
    }

    @Singleton
    @Primary
    @Requires(beans={DataSource.class})
    public StorageProvider sqlStorageProvider(BeanContext beanContext, JobMapper jobMapper) {
        DataSource dataSource = this.configuration.getDatabase().getDatasource().map(datasourceName -> (DataSource)beanContext.getBean(DataSource.class, Qualifiers.byName((String)datasourceName))).orElse((DataSource)beanContext.getBean(DataSource.class));
        String tablePrefix = this.configuration.getDatabase().getTablePrefix().orElse(null);
        StorageProviderUtils.DatabaseOptions databaseOptions = this.configuration.getDatabase().isSkipCreate() ? StorageProviderUtils.DatabaseOptions.SKIP_CREATE : StorageProviderUtils.DatabaseOptions.CREATE;
        StorageProvider storageProvider = SqlStorageProviderFactory.using((DataSource)dataSource, (String)tablePrefix, (StorageProviderUtils.DatabaseOptions)databaseOptions);
        storageProvider.setJobMapper(jobMapper);
        return storageProvider;
    }

    @Singleton
    @Primary
    @Requires(beans={MongoClient.class})
    public StorageProvider mongoDBStorageProvider(MongoClient mongoClient, JobMapper jobMapper) {
        String databaseName = this.configuration.getDatabase().getDatabaseName().orElse(null);
        String tablePrefix = this.configuration.getDatabase().getTablePrefix().orElse(null);
        StorageProviderUtils.DatabaseOptions databaseOptions = this.configuration.getDatabase().isSkipCreate() ? StorageProviderUtils.DatabaseOptions.SKIP_CREATE : StorageProviderUtils.DatabaseOptions.CREATE;
        MongoDBStorageProvider mongoDBStorageProvider = new MongoDBStorageProvider(mongoClient, databaseName, tablePrefix, databaseOptions);
        mongoDBStorageProvider.setJobMapper(jobMapper);
        return mongoDBStorageProvider;
    }

    @Singleton
    @Primary
    @Requires(beans={RedisClient.class})
    public StorageProvider lettuceRedisStorageProvider(RedisClient redisClient, JobMapper jobMapper) {
        String tablePrefix = this.configuration.getDatabase().getTablePrefix().orElse(null);
        LettuceRedisStorageProvider lettuceRedisStorageProvider = new LettuceRedisStorageProvider(redisClient, tablePrefix);
        lettuceRedisStorageProvider.setJobMapper(jobMapper);
        return lettuceRedisStorageProvider;
    }

    @Singleton
    @Primary
    @Requires(beans={RestHighLevelClient.class})
    public StorageProvider elasticSearchStorageProvider(RestHighLevelClient restHighLevelClient, JobMapper jobMapper) {
        String tablePrefix = this.configuration.getDatabase().getTablePrefix().orElse(null);
        StorageProviderUtils.DatabaseOptions databaseOptions = this.configuration.getDatabase().isSkipCreate() ? StorageProviderUtils.DatabaseOptions.SKIP_CREATE : StorageProviderUtils.DatabaseOptions.CREATE;
        ElasticSearchStorageProvider elasticSearchStorageProvider = new ElasticSearchStorageProvider(restHighLevelClient, tablePrefix, databaseOptions);
        elasticSearchStorageProvider.setJobMapper(jobMapper);
        return elasticSearchStorageProvider;
    }
}

