/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import io.micronaut.inject.ExecutableMethod;
import java.time.ZoneId;
import java.util.Collections;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.micronaut.annotations.Recurring;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.cron.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunrRecurringJobScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunrRecurringJobScheduler.class);
    private final JobScheduler jobScheduler;

    public JobRunrRecurringJobScheduler(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public void schedule(ExecutableMethod<?, ?> method) {
        if (method.getTargetMethod().getParameterCount() > 0) {
            throw new IllegalStateException("Methods annotated with " + Recurring.class.getName() + " can not have parameters.");
        }
        String id = this.getId(method);
        String cron = this.getCron(method);
        if ("-".equals(cron)) {
            if (id == null) {
                LOGGER.warn("You are trying to disable a recurring job using placeholders but did not define an id.");
            } else {
                this.jobScheduler.delete(id);
            }
        } else {
            JobDetails jobDetails = this.getJobDetails(method);
            ZoneId zoneId = this.getZoneId(method);
            this.jobScheduler.scheduleRecurrently(id, jobDetails, CronExpression.create((String)cron), zoneId);
        }
    }

    private String getId(ExecutableMethod<?, ?> method) {
        return method.stringValue(Recurring.class, "id").orElse(null);
    }

    private String getCron(ExecutableMethod<?, ?> method) {
        return (String)method.stringValue(Recurring.class, "cron").orElseThrow(() -> new IllegalArgumentException("Cron attribute is required"));
    }

    private JobDetails getJobDetails(ExecutableMethod<?, ?> method) {
        JobDetails jobDetails = new JobDetails(method.getTargetMethod().getDeclaringClass().getName(), null, method.getTargetMethod().getName(), Collections.emptyList());
        jobDetails.setCacheable(true);
        return jobDetails;
    }

    private ZoneId getZoneId(ExecutableMethod<?, ?> method) {
        return method.stringValue(Recurring.class, "zone").map(ZoneId::of).orElse(ZoneId.systemDefault());
    }
}

