/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.micronaut.autoconfigure.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.AbstractHealthIndicator;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.annotation.Readiness;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jobrunr.micronaut.autoconfigure.JobRunrConfiguration;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.utils.CollectionUtils;

@Singleton
@Requirements(value={@Requires(classes={HealthIndicator.class}, beans={BackgroundJobServer.class}), @Requires(property="jobrunr.health.enabled", value="true", defaultValue="true")})
@Readiness
public class JobRunrHealthIndicator
extends AbstractHealthIndicator<Map<String, String>> {
    private final BackgroundJobServer backgroundJobServer;
    private final JobRunrConfiguration configuration;

    public JobRunrHealthIndicator(BackgroundJobServer backgroundJobServer, JobRunrConfiguration configuration) {
        this.backgroundJobServer = backgroundJobServer;
        this.configuration = configuration;
    }

    protected String getName() {
        return "jobrunr";
    }

    protected Map<String, String> getHealthInformation() {
        if (!this.configuration.getBackgroundJobServer().isEnabled()) {
            this.healthStatus = HealthStatus.UP;
            return CollectionUtils.mapOf((Object)"backgroundJobServer", (Object)"disabled");
        }
        if (this.backgroundJobServer.isRunning()) {
            this.healthStatus = HealthStatus.UP;
            return CollectionUtils.mapOf((Object)"backgroundJobServer", (Object)"enabled", (Object)"backgroundJobServerStatus", (Object)"running");
        }
        this.healthStatus = HealthStatus.DOWN;
        return CollectionUtils.mapOf((Object)"backgroundJobServer", (Object)"enabled", (Object)"backgroundJobServerStatus", (Object)"stopped");
    }
}

