/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.micronaut.autoconfigure.storage;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import javax.sql.DataSource;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.micronaut.autoconfigure.JobRunrConfiguration;
import org.jobrunr.micronaut.autoconfigure.storage.sql.DelegatingDatasourceExtractor;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.SqlStorageProviderFactory;

@Factory
@Requirements(value={@Requires(beans={DataSource.class}), @Requires(property="jobrunr.database.type", value="sql", defaultValue="sql")})
public class JobRunrSqlStorageProviderFactory {
    @Inject
    private JobRunrConfiguration configuration;

    @Singleton
    @Primary
    public StorageProvider sqlStorageProvider(BeanContext beanContext, JobMapper jobMapper) {
        DataSource dataSource = this.getDataSource(beanContext);
        String tablePrefix = this.configuration.getDatabase().getTablePrefix().orElse(null);
        StorageProviderUtils.DatabaseOptions databaseOptions = this.configuration.getDatabase().isSkipCreate() ? StorageProviderUtils.DatabaseOptions.SKIP_CREATE : StorageProviderUtils.DatabaseOptions.CREATE;
        StorageProvider storageProvider = SqlStorageProviderFactory.using((DataSource)dataSource, (String)tablePrefix, (StorageProviderUtils.DatabaseOptions)databaseOptions);
        storageProvider.setJobMapper(jobMapper);
        return storageProvider;
    }

    private DataSource getDataSource(BeanContext beanContext) {
        DataSource dataSource = this.configuration.getDatabase().getDatasource().map(datasourceName -> (DataSource)beanContext.getBean(DataSource.class, Qualifiers.byName((String)datasourceName))).orElseGet(() -> (DataSource)beanContext.getBean(DataSource.class));
        for (Class<?> superClass = dataSource.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!"io.micronaut.transaction.jdbc.DelegatingDataSource".equals(superClass.getName())) continue;
            return DelegatingDatasourceExtractor.extract(dataSource);
        }
        return dataSource;
    }
}

