/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.micronaut.autoconfigure;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.jobs.details.CachingJobDetailsGenerator;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.filters.RetryFilter;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.micronaut.autoconfigure.JobRunrConfiguration;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.storage.InMemoryStorageProvider;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.jobrunr.utils.reflection.ReflectionUtils;

@Factory
public class JobRunrFactory {
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private JobRunrConfiguration configuration;

    @Singleton
    @Requires(property="jobrunr.job-scheduler.enabled", value="true")
    public JobScheduler jobScheduler(StorageProvider storageProvider) {
        JobDetailsGenerator jobDetailsGenerator = (JobDetailsGenerator)ReflectionUtils.newInstance((String)this.configuration.getJobScheduler().getJobDetailsGenerator().orElse(CachingJobDetailsGenerator.class.getName()), (Object[])new Object[0]);
        return new JobScheduler(storageProvider, jobDetailsGenerator, Collections.emptyList());
    }

    @Singleton
    @Requires(property="jobrunr.job-scheduler.enabled", value="true")
    public JobRequestScheduler jobRequestScheduler(StorageProvider storageProvider) {
        return new JobRequestScheduler(storageProvider, Collections.emptyList());
    }

    @Singleton
    @Requires(property="jobrunr.background-job-server.enabled", value="true")
    public BackgroundJobServerConfiguration backgroundJobServerConfiguration() {
        BackgroundJobServerConfiguration backgroundJobServerConfiguration = BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration();
        this.configuration.getBackgroundJobServer().getName().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andName(arg_0));
        this.configuration.getBackgroundJobServer().getPollIntervalInSeconds().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPollIntervalInSeconds(arg_0));
        this.configuration.getBackgroundJobServer().getWorkerCount().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andWorkerCount(arg_0));
        this.configuration.getBackgroundJobServer().getDeleteSucceededJobsAfter().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andDeleteSucceededJobsAfter(arg_0));
        this.configuration.getBackgroundJobServer().getPermanentlyDeleteDeletedJobsAfter().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPermanentlyDeleteDeletedJobsAfter(arg_0));
        this.configuration.getBackgroundJobServer().getScheduledJobsRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andScheduledJobsRequestSize(arg_0));
        this.configuration.getBackgroundJobServer().getOrphanedJobsRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andOrphanedJobsRequestSize(arg_0));
        this.configuration.getBackgroundJobServer().getSucceededJobsRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andSucceededJobsRequestSize(arg_0));
        return backgroundJobServerConfiguration;
    }

    @Singleton
    @Requires(property="jobrunr.background-job-server.enabled", value="true")
    public BackgroundJobServer backgroundJobServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobActivator jobActivator, BackgroundJobServerConfiguration backgroundJobServerConfiguration) {
        int defaultNbrOfRetries = this.configuration.getJobs().getDefaultNumberOfRetries().orElse(10);
        int retryBackOffTimeSeed = this.configuration.getJobs().getRetryBackOffTimeSeed().orElse(3);
        BackgroundJobServer backgroundJobServer = new BackgroundJobServer(storageProvider, jobRunrJsonMapper, jobActivator, backgroundJobServerConfiguration);
        backgroundJobServer.setJobFilters(Collections.singletonList(new RetryFilter(defaultNbrOfRetries, retryBackOffTimeSeed)));
        return backgroundJobServer;
    }

    @Singleton
    @Requires(property="jobrunr.dashboard.enabled", value="true")
    public JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration() {
        JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration = JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration();
        this.configuration.getDashboard().getPort().ifPresent(arg_0 -> ((JobRunrDashboardWebServerConfiguration)dashboardWebServerConfiguration).andPort(arg_0));
        if (this.configuration.getDashboard().getUsername().isPresent() && this.configuration.getDashboard().getPassword().isPresent()) {
            dashboardWebServerConfiguration.andBasicAuthentication(this.configuration.getDashboard().getUsername().get(), this.configuration.getDashboard().getPassword().get());
        }
        dashboardWebServerConfiguration.andAllowAnonymousDataUsage(this.configuration.getMiscellaneous().isAllowAnonymousDataUsage());
        return dashboardWebServerConfiguration;
    }

    @Singleton
    @Requires(property="jobrunr.dashboard.enabled", value="true")
    public JobRunrDashboardWebServer dashboardWebServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration) {
        return new JobRunrDashboardWebServer(storageProvider, jobRunrJsonMapper, dashboardWebServerConfiguration);
    }

    @Singleton
    public JobActivator jobActivator() {
        return new JobActivator(){

            public <T> T activateJob(Class<T> aClass) {
                return (T)JobRunrFactory.this.applicationContext.getBean(aClass);
            }
        };
    }

    @Singleton
    public JobMapper jobMapper(JsonMapper jobRunrJsonMapper) {
        return new JobMapper(jobRunrJsonMapper);
    }

    @Singleton
    public JsonMapper jobRunrJsonMapper() {
        return new JacksonJsonMapper();
    }

    @Singleton
    @Requires(missingBeans={StorageProvider.class})
    public StorageProvider storageProvider(JobMapper jobMapper) {
        InMemoryStorageProvider storageProvider = new InMemoryStorageProvider();
        storageProvider.setJobMapper(jobMapper);
        return storageProvider;
    }
}

