/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.micronaut.autoconfigure;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.bind.annotation.Bindable;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.Optional;
import org.jobrunr.server.configuration.BackgroundJobServerThreadType;

@Context
@ConfigurationProperties(value="jobrunr")
public interface JobRunrConfiguration {
    @NotNull
    public DatabaseConfiguration getDatabase();

    @NotNull
    public JobsConfiguration getJobs();

    @NotNull
    public JobSchedulerConfiguration getJobScheduler();

    @NotNull
    public BackgroundJobServerConfiguration getBackgroundJobServer();

    @NotNull
    public DashboardConfiguration getDashboard();

    @NotNull
    public MiscellaneousConfiguration getMiscellaneous();

    @ConfigurationProperties(value="metrics")
    public static interface MetricsConfiguration {
        @Bindable(defaultValue="false")
        public boolean isEnabled();
    }

    @ConfigurationProperties(value="miscellaneous")
    public static interface MiscellaneousConfiguration {
        @Bindable(defaultValue="true")
        public boolean isAllowAnonymousDataUsage();
    }

    @ConfigurationProperties(value="dashboard")
    public static interface DashboardConfiguration {
        @Bindable(defaultValue="false")
        public boolean isEnabled();

        public Optional<Integer> getPort();

        public Optional<String> getUsername();

        public Optional<String> getPassword();
    }

    @ConfigurationProperties(value="backgroundJobServer")
    public static interface BackgroundJobServerConfiguration {
        public Optional<String> getName();

        @Bindable(defaultValue="false")
        public boolean isEnabled();

        public Optional<Integer> getWorkerCount();

        public Optional<BackgroundJobServerThreadType> getThreadType();

        public Optional<Integer> getPollIntervalInSeconds();

        public Optional<Integer> getScheduledJobsRequestSize();

        public Optional<Integer> getOrphanedJobsRequestSize();

        public Optional<Integer> getSucceededJobsRequestSize();

        public Optional<Duration> getDeleteSucceededJobsAfter();

        public Optional<Duration> getPermanentlyDeleteDeletedJobsAfter();

        public Optional<Duration> getInterruptJobsAwaitDurationOnStop();

        @NotNull
        public MetricsConfiguration getMetrics();
    }

    @ConfigurationProperties(value="jobScheduler")
    public static interface JobSchedulerConfiguration {
        @Bindable(defaultValue="true")
        public boolean isEnabled();

        public Optional<String> getJobDetailsGenerator();
    }

    @ConfigurationProperties(value="database")
    public static interface DatabaseConfiguration {
        @Bindable(defaultValue="false")
        public boolean isSkipCreate();

        public Optional<String> getDatabaseName();

        public Optional<String> getTablePrefix();

        public Optional<String> getDatasource();

        public Optional<String> getType();
    }

    @ConfigurationProperties(value="jobs")
    public static interface JobsConfiguration {
        public Optional<Integer> getDefaultNumberOfRetries();

        public Optional<Integer> getRetryBackOffTimeSeed();

        @NotNull
        public MetricsConfiguration getMetrics();
    }
}

