/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.micronaut.autoconfigure;

import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.runtime.event.annotation.EventListener;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.micronaut.autoconfigure.JobRunrConfiguration;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.storage.StorageProvider;

@Singleton
public class JobRunrStarter {
    @Inject
    private JobRunrConfiguration configuration;
    @Inject
    private StorageProvider storageProvider;
    @Inject
    private Optional<BackgroundJobServer> backgroundJobServer;
    @Inject
    private Optional<JobRunrDashboardWebServer> dashboardWebServer;

    @EventListener
    void startup(StartupEvent event) {
        if (this.configuration.getBackgroundJobServer().isEnabled()) {
            this.backgroundJobServer.get().start();
        }
        if (this.configuration.getDashboard().isEnabled()) {
            this.dashboardWebServer.get().start();
        }
    }

    @EventListener
    void shutdown(ShutdownEvent event) {
        if (this.configuration.getBackgroundJobServer().isEnabled()) {
            this.backgroundJobServer.get().stop();
        }
        if (this.configuration.getDashboard().isEnabled()) {
            this.dashboardWebServer.get().stop();
        }
        this.storageProvider.close();
    }
}

