/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.spring.autoconfigure.storage;

import javax.sql.DataSource;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.spring.autoconfigure.JobRunrProperties;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.SqlStorageProviderFactory;
import org.jobrunr.utils.StringUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.sql.init.dependency.DependsOnDatabaseInitialization;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="org.jobrunr.database", name={"type"}, havingValue="sql", matchIfMissing=true)
public class JobRunrSqlStorageAutoConfiguration {
    @Bean(name={"storageProvider"}, destroyMethod="close")
    @DependsOnDatabaseInitialization
    @ConditionalOnMissingBean
    public StorageProvider sqlStorageProvider(BeanFactory beanFactory, JobMapper jobMapper, JobRunrProperties properties) {
        String tablePrefix = properties.getDatabase().getTablePrefix();
        StorageProviderUtils.DatabaseOptions databaseOptions = properties.getDatabase().isSkipCreate() ? StorageProviderUtils.DatabaseOptions.SKIP_CREATE : StorageProviderUtils.DatabaseOptions.CREATE;
        StorageProvider storageProvider = SqlStorageProviderFactory.using((DataSource)this.getDataSource(beanFactory, properties), (String)tablePrefix, (StorageProviderUtils.DatabaseOptions)databaseOptions);
        storageProvider.setJobMapper(jobMapper);
        return storageProvider;
    }

    private DataSource getDataSource(BeanFactory beanFactory, JobRunrProperties properties) {
        if (StringUtils.isNotNullOrEmpty((String)properties.getDatabase().getDatasource())) {
            return (DataSource)beanFactory.getBean(properties.getDatabase().getDatasource(), DataSource.class);
        }
        return (DataSource)beanFactory.getBean(DataSource.class);
    }
}

