/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.lang.reflect.Method;
import java.time.ZoneId;
import java.util.ArrayList;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.annotations.Recurring;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.ScheduleExpressionType;
import org.jobrunr.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

public class RecurringJobPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
EmbeddedValueResolverAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecurringJobPostProcessor.class);
    private BeanFactory beanFactory;
    private StringValueResolver embeddedValueResolver;
    private RecurringJobFinderMethodCallback recurringJobFinderMethodCallback;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)this.recurringJobFinderMethodCallback);
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void afterPropertiesSet() {
        this.recurringJobFinderMethodCallback = new RecurringJobFinderMethodCallback(this.beanFactory, this.embeddedValueResolver);
    }

    private static class RecurringJobFinderMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final BeanFactory beanFactory;
        private final StringValueResolver embeddedValueResolver;

        public RecurringJobFinderMethodCallback(BeanFactory beanFactory, StringValueResolver resolver) {
            this.beanFactory = beanFactory;
            this.embeddedValueResolver = resolver;
        }

        public void doWith(Method method) throws IllegalArgumentException {
            String interval;
            if (!method.isAnnotationPresent(Recurring.class)) {
                return;
            }
            if (this.hasParametersOutsideOfJobContext(method)) {
                throw new IllegalStateException("Methods annotated with " + Recurring.class.getName() + " can only have zero parameters or a single parameter of type JobContext.");
            }
            Recurring recurringAnnotation = method.getAnnotation(Recurring.class);
            String id = this.getId(recurringAnnotation);
            String cron = this.resolveStringValue(recurringAnnotation.cron());
            String scheduleExpression = ScheduleExpressionType.selectConfiguredScheduleExpression((String)cron, (String)(interval = this.resolveStringValue(recurringAnnotation.interval())));
            if ("-".equals(scheduleExpression)) {
                if (id == null) {
                    LOGGER.warn("You are trying to disable a recurring job using placeholders but did not define an id.");
                } else {
                    ((JobScheduler)this.beanFactory.getBean(JobScheduler.class)).deleteRecurringJob(id);
                }
            } else {
                JobDetails jobDetails = this.getJobDetails(method);
                ZoneId zoneId = this.getZoneId(recurringAnnotation);
                Schedule schedule = ScheduleExpressionType.createScheduleFromString((String)scheduleExpression);
                RecurringJob recurringJob = new RecurringJob(id, jobDetails, schedule, zoneId, RecurringJob.CreatedBy.ANNOTATION);
                ((JobScheduler)this.beanFactory.getBean(JobScheduler.class)).scheduleRecurrently(recurringJob);
            }
        }

        private boolean hasParametersOutsideOfJobContext(Method method) {
            if (method.getParameterCount() == 0) {
                return false;
            }
            if (method.getParameterCount() > 1) {
                return true;
            }
            return !method.getParameterTypes()[0].equals(JobContext.class);
        }

        private String getId(Recurring recurringAnnotation) {
            String id = this.resolveStringValue(recurringAnnotation.id());
            return StringUtils.isNullOrEmpty((String)id) ? null : id;
        }

        private JobDetails getJobDetails(Method method) {
            ArrayList<JobParameter> jobParameters = new ArrayList<JobParameter>();
            if (method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(JobContext.class)) {
                jobParameters.add(JobParameter.JobContext);
            }
            JobDetails jobDetails = new JobDetails(method.getDeclaringClass().getName(), null, method.getName(), jobParameters);
            jobDetails.setCacheable(true);
            return jobDetails;
        }

        private ZoneId getZoneId(Recurring recurringAnnotation) {
            String zoneId = this.resolveStringValue(recurringAnnotation.zoneId());
            return StringUtils.isNullOrEmpty((String)zoneId) ? ZoneId.systemDefault() : ZoneId.of(zoneId);
        }

        private String resolveStringValue(String value) {
            if (this.embeddedValueResolver != null && value != null) {
                return this.embeddedValueResolver.resolveStringValue(value);
            }
            return value;
        }
    }
}

