/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.jobrunr.jobs.annotations.AsyncJob;
import org.jobrunr.jobs.annotations.Job;
import org.jobrunr.scheduling.AsyncJobInterceptor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

public class AsyncJobPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private final AsyncJobMethodValidator asyncJobMethodValidator = new AsyncJobMethodValidator();
    private AsyncJobInterceptor asyncJobInterceptor;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (AnnotatedElementUtils.hasAnnotation(bean.getClass(), AsyncJob.class)) {
            ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)this.asyncJobMethodValidator);
            return this.applyJobEnhancement(bean);
        }
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.asyncJobInterceptor = new AsyncJobInterceptor(beanFactory);
    }

    public Object applyJobEnhancement(Object bean) {
        if (this.asyncJobInterceptor == null) {
            throw new IllegalStateException("Bean Factory was not set and AsyncJobInterceptor could not be created");
        }
        ProxyFactory proxyFactory = new ProxyFactory(bean);
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addAdvice((Advice)this.asyncJobInterceptor);
        return proxyFactory.getProxy();
    }

    private static class AsyncJobMethodValidator
    implements ReflectionUtils.MethodCallback {
        private AsyncJobMethodValidator() {
        }

        public void doWith(Method method) throws IllegalArgumentException {
            if (AsyncJobMethodValidator.isJobRunrJobWithAReturnValue(method)) {
                throw new IllegalArgumentException("An @AsyncJob cannot have a return value. " + String.valueOf(method) + " is defined as an @AsyncJob but has a return value.");
            }
        }

        private static boolean isJobRunrJobWithAReturnValue(Method method) {
            return method.isAnnotationPresent(Job.class) && !method.getReturnType().equals(Void.TYPE);
        }
    }
}

