/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.time.Duration;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.scheduling.BackgroundJob;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.gson.GsonJsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class JobRunrAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr", name={"job_scheduler"}, havingValue="true", matchIfMissing=true)
    public JobScheduler jobScheduler(StorageProvider storageProvider) {
        JobScheduler jobScheduler = new JobScheduler(storageProvider);
        BackgroundJob.setJobScheduler((JobScheduler)jobScheduler);
        return jobScheduler;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr", name={"background_job_server"}, havingValue="true")
    public BackgroundJobServer backgroundJobServer(StorageProvider storageProvider, JobActivator jobActivator, BackgroundJobServerConfiguration backgroundJobServerConfiguration) {
        BackgroundJobServer backgroundJobServer = new BackgroundJobServer(storageProvider, jobActivator, backgroundJobServerConfiguration);
        backgroundJobServer.start();
        return backgroundJobServer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr", name={"background_job_server"}, havingValue="true")
    public BackgroundJobServerConfiguration backgroundJobServerConfiguration(Environment environment) {
        BackgroundJobServerConfiguration backgroundJobServerConfiguration = BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration();
        if (environment.containsProperty("org.jobrunr.background_job_server.worker_count")) {
            backgroundJobServerConfiguration.andWorkerCount(Integer.parseInt(environment.getRequiredProperty("org.jobrunr.background_job_server.worker_count")));
        }
        if (environment.containsProperty("org.jobrunr.background_job_server.poll_interval")) {
            backgroundJobServerConfiguration.andPollIntervalInSeconds(Integer.parseInt(environment.getRequiredProperty("org.jobrunr.background_job_server.poll_interval")));
        }
        if (environment.containsProperty("org.jobrunr.background_job_server.delete_succeeded_jobs_after")) {
            backgroundJobServerConfiguration.andDeleteSucceededJobsAfter(Duration.ofHours(Integer.parseInt(environment.getRequiredProperty("org.jobrunr.background_job_server.delete_succeeded_jobs_after"))));
        }
        if (environment.containsProperty("org.jobrunr.background_job_server.permanently_delete_deleted_jobs_after")) {
            backgroundJobServerConfiguration.andPermanentlyDeleteDeletedJobsAfter(Duration.ofHours(Integer.parseInt(environment.getRequiredProperty("org.jobrunr.background_job_server.permanently_delete_deleted_jobs_after"))));
        }
        return backgroundJobServerConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr", name={"dashboard"}, havingValue="true")
    public JobRunrDashboardWebServer dashboardWebServer(StorageProvider storageProvider, JsonMapper jsonMapper, JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration) {
        JobRunrDashboardWebServer dashboardWebServer = new JobRunrDashboardWebServer(storageProvider, jsonMapper, dashboardWebServerConfiguration);
        dashboardWebServer.start();
        return dashboardWebServer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr", name={"dashboard"}, havingValue="true")
    public JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration(Environment environment) {
        JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration = JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration();
        if (environment.containsProperty("org.jobrunr.dashboard.port")) {
            dashboardWebServerConfiguration.andPort(Integer.parseInt(environment.getRequiredProperty("org.jobrunr.dashboard.port")));
        }
        return dashboardWebServerConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean
    public JobActivator jobActivator(ApplicationContext applicationContext) {
        return arg_0 -> ((ApplicationContext)applicationContext).getBean(arg_0);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMapper jobMapper(JsonMapper jsonMapper) {
        return new JobMapper(jsonMapper);
    }

    @Bean(name={"jsonMapper"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={ObjectMapper.class})
    public JsonMapper jacksonJsonMapper() {
        return new JacksonJsonMapper();
    }

    @Bean(name={"jsonMapper"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Gson.class})
    public JsonMapper gsonJsonMapper() {
        return new GsonJsonMapper();
    }
}

