/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.autoconfigure.storage;

import javax.sql.DataSource;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.sql.common.DefaultSqlStorageProvider;
import org.jobrunr.storage.sql.common.SqlStorageProviderFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JobRunrSqlStorageAutoConfiguration {
    @Bean(name={"storageProvider"}, destroyMethod="close")
    @ConditionalOnMissingBean
    public StorageProvider sqlStorageProvider(DataSource dataSource, JobMapper jobMapper, Environment environment) {
        if (!environment.containsProperty("org.jobrunr.database.skip-create") && !Boolean.parseBoolean(environment.getProperty("org.jobrunr.database.skip-create"))) {
            StorageProvider storageProvider = SqlStorageProviderFactory.using((DataSource)dataSource);
            storageProvider.setJobMapper(jobMapper);
            return storageProvider;
        }
        DefaultSqlStorageProvider storageProvider = new DefaultSqlStorageProvider(dataSource, DefaultSqlStorageProvider.DatabaseOptions.SKIP_CREATE);
        storageProvider.setJobMapper(jobMapper);
        return storageProvider;
    }
}

