/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import javax.json.bind.Jsonb;
import org.jobrunr.autoconfigure.JobRunrProperties;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.scheduling.BackgroundJob;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.gson.GsonJsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.jobrunr.utils.mapper.jsonb.JsonbJsonMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JobRunrProperties.class})
public class JobRunrAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.job-scheduler", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JobScheduler jobScheduler(StorageProvider storageProvider) {
        JobScheduler jobScheduler = new JobScheduler(storageProvider);
        BackgroundJob.setJobScheduler((JobScheduler)jobScheduler);
        return jobScheduler;
    }

    @Bean(destroyMethod="stop")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.background-job-server", name={"enabled"}, havingValue="true")
    public BackgroundJobServer backgroundJobServer(StorageProvider storageProvider, JobActivator jobActivator, BackgroundJobServerConfiguration backgroundJobServerConfiguration) {
        BackgroundJobServer backgroundJobServer = new BackgroundJobServer(storageProvider, jobActivator, backgroundJobServerConfiguration);
        backgroundJobServer.start();
        return backgroundJobServer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.background-job-server", name={"enabled"}, havingValue="true")
    public BackgroundJobServerConfiguration backgroundJobServerConfiguration(JobRunrProperties properties) {
        PropertyMapper map = PropertyMapper.get();
        BackgroundJobServerConfiguration backgroundJobServerConfiguration = BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration();
        JobRunrProperties.BackgroundJobServer backgroundJobServerProperties = properties.getBackgroundJobServer();
        map.from(backgroundJobServerProperties::getWorkerCount).whenNonNull().to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andWorkerCount(arg_0));
        map.from(backgroundJobServerProperties::getPollIntervalInSeconds).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPollIntervalInSeconds(arg_0));
        map.from(backgroundJobServerProperties::getDeleteSucceededJobsAfter).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andDeleteSucceededJobsAfter(arg_0));
        map.from(backgroundJobServerProperties::getPermanentlyDeleteDeletedJobsAfter).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPermanentlyDeleteDeletedJobsAfter(arg_0));
        return backgroundJobServerConfiguration;
    }

    @Bean(destroyMethod="stop")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.dashboard", name={"enabled"}, havingValue="true")
    public JobRunrDashboardWebServer dashboardWebServer(StorageProvider storageProvider, JsonMapper jsonMapper, JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration) {
        JobRunrDashboardWebServer dashboardWebServer = new JobRunrDashboardWebServer(storageProvider, jsonMapper, dashboardWebServerConfiguration);
        dashboardWebServer.start();
        return dashboardWebServer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.dashboard", name={"enabled"}, havingValue="true")
    public JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration(JobRunrProperties properties) {
        return JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(properties.getDashboard().getPort());
    }

    @Bean
    @ConditionalOnMissingBean
    public JobActivator jobActivator(ApplicationContext applicationContext) {
        return arg_0 -> ((ApplicationContext)applicationContext).getBean(arg_0);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMapper jobMapper(JsonMapper jsonMapper) {
        return new JobMapper(jsonMapper);
    }

    @ConditionalOnClass(value={Jsonb.class})
    @ConditionalOnResource(resources={"classpath:META-INF/services/javax.json.bind.spi.JsonbProvider", "classpath:META-INF/services/javax.json.spi.JsonProvider"})
    public class JobRunrJsonbAutoConfiguration {
        @Bean(name={"jsonMapper"})
        @ConditionalOnMissingBean
        public JsonMapper jsonbJsonMapper() {
            return new JsonbJsonMapper();
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    public class JobRunrJacksonAutoConfiguration {
        @Bean(name={"jsonMapper"})
        @ConditionalOnMissingBean
        public JsonMapper jacksonJsonMapper() {
            return new JacksonJsonMapper();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Gson.class})
    public class JobRunrGsonAutoConfiguration {
        @Bean(name={"jsonMapper"})
        @ConditionalOnMissingBean
        public JsonMapper gsonJsonMapper() {
            return new GsonJsonMapper();
        }
    }
}

