/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.lang.reflect.Method;
import java.time.ZoneId;
import java.util.ArrayList;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.cron.CronExpression;
import org.jobrunr.spring.annotations.Recurring;
import org.jobrunr.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

public class RecurringJobPostProcessor
implements BeanPostProcessor,
EmbeddedValueResolverAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecurringJobPostProcessor.class);
    private final JobScheduler jobScheduler;
    private StringValueResolver embeddedValueResolver;
    private RecurringJobFinderMethodCallback recurringJobFinderMethodCallback;

    public RecurringJobPostProcessor(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)this.recurringJobFinderMethodCallback);
        return bean;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void afterPropertiesSet() {
        this.recurringJobFinderMethodCallback = new RecurringJobFinderMethodCallback(this.jobScheduler, this.embeddedValueResolver);
    }

    private static class RecurringJobFinderMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final JobScheduler jobScheduler;
        private final StringValueResolver embeddedValueResolver;

        public RecurringJobFinderMethodCallback(JobScheduler jobScheduler, StringValueResolver resolver) {
            this.jobScheduler = jobScheduler;
            this.embeddedValueResolver = resolver;
        }

        public void doWith(Method method) throws IllegalArgumentException {
            if (!method.isAnnotationPresent(Recurring.class)) {
                return;
            }
            if (method.getParameterCount() > 0) {
                throw new IllegalStateException("Methods annotated with " + Recurring.class.getName() + " can not have parameters.");
            }
            Recurring recurringAnnotation = method.getAnnotation(Recurring.class);
            String id = this.getId(recurringAnnotation);
            String cron = this.resolveStringValue(recurringAnnotation.cron());
            if ("-".equals(cron)) {
                if (id == null) {
                    LOGGER.warn("You are trying to disable a recurring job using placeholders but did not define an id.");
                } else {
                    this.jobScheduler.delete(id);
                }
            } else {
                JobDetails jobDetails = this.getJobDetails(method);
                CronExpression cronExpression = CronExpression.create((String)cron);
                ZoneId zoneId = this.getZoneId(recurringAnnotation);
                this.jobScheduler.scheduleRecurrently(id, jobDetails, cronExpression, zoneId);
            }
        }

        private String getId(Recurring recurringAnnotation) {
            String id = this.resolveStringValue(recurringAnnotation.id());
            return StringUtils.isNullOrEmpty((String)id) ? null : id;
        }

        private JobDetails getJobDetails(Method method) {
            return new JobDetails(method.getDeclaringClass().getName(), null, method.getName(), new ArrayList());
        }

        private CronExpression getCronExpression(Recurring recurringAnnotation) {
            String cron = this.resolveStringValue(recurringAnnotation.cron());
            return CronExpression.create((String)cron);
        }

        private ZoneId getZoneId(Recurring recurringAnnotation) {
            String zoneId = this.resolveStringValue(recurringAnnotation.zoneId());
            return StringUtils.isNullOrEmpty((String)zoneId) ? ZoneId.systemDefault() : ZoneId.of(zoneId);
        }

        private String resolveStringValue(String value) {
            if (this.embeddedValueResolver != null && value != null) {
                return this.embeddedValueResolver.resolveStringValue(value);
            }
            return value;
        }
    }
}

