/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.extension.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.Optional;
import org.jobrunr.quarkus.autoconfigure.JobRunrConfiguration;
import org.jobrunr.quarkus.autoconfigure.JobRunrProducer;
import org.jobrunr.quarkus.autoconfigure.JobRunrStarter;
import org.jobrunr.quarkus.autoconfigure.health.JobRunrHealthCheck;
import org.jobrunr.quarkus.autoconfigure.metrics.JobRunrMetricsProducer;
import org.jobrunr.quarkus.autoconfigure.metrics.JobRunrMetricsStarter;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrElasticSearchStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrInMemoryStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrMongoDBStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrSqlStorageProviderProducer;
import org.jobrunr.quarkus.extension.deployment.RecurringJobsFinder;
import org.jobrunr.scheduling.JobRunrRecurringJobRecorder;

class JobRunrExtensionProcessor {
    private static final String FEATURE = "jobrunr";

    JobRunrExtensionProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem produce(Capabilities capabilities) {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{JobRunrProducer.class, JobRunrStarter.class, this.storageProvider(capabilities), this.jsonMapper(capabilities), JobRunrMetricsProducer.StorageProviderMetricsProducer.class}).build();
    }

    @BuildStep
    AdditionalBeanBuildItem addMetrics(Optional<MetricsCapabilityBuildItem> metricsCapability, JobRunrConfiguration jobRunrConfiguration) {
        if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer")) {
            AdditionalBeanBuildItem.Builder additionalBeanBuildItemBuilder = AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{JobRunrMetricsStarter.class}).addBeanClasses(new Class[]{JobRunrMetricsProducer.StorageProviderMetricsProducer.class});
            if (jobRunrConfiguration.backgroundJobServer.enabled) {
                additionalBeanBuildItemBuilder.addBeanClasses(new Class[]{JobRunrMetricsProducer.BackgroundJobServerMetricsProducer.class});
            }
            return additionalBeanBuildItemBuilder.build();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void findRecurringJobAnnotationsAndScheduleThem(RecorderContext recorderContext, CombinedIndexBuildItem index, BeanContainerBuildItem beanContainer, JobRunrRecurringJobRecorder recorder) throws Exception {
        new RecurringJobsFinder(recorderContext, index, beanContainer, recorder).findRecurringJobsAndScheduleThem();
    }

    @BuildStep
    HealthBuildItem addHealthCheck(Capabilities capabilities, JobRunrConfiguration jobRunrConfiguration) {
        if (capabilities.isPresent("io.quarkus.smallrye.health")) {
            return new HealthBuildItem(JobRunrHealthCheck.class.getName(), jobRunrConfiguration.healthEnabled);
        }
        return null;
    }

    private Class<?> jsonMapper(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.jsonb")) {
            return JobRunrProducer.JobRunrJsonBJsonMapperProducer.class;
        }
        if (capabilities.isPresent("io.quarkus.jackson")) {
            return JobRunrProducer.JobRunrJacksonJsonMapperProducer.class;
        }
        throw new IllegalStateException("Either JSON-B or Jackson should be added via a Quarkus extension");
    }

    private Class<?> storageProvider(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            return JobRunrSqlStorageProviderProducer.class;
        }
        if (capabilities.isPresent("io.quarkus.mongodb-client")) {
            return JobRunrMongoDBStorageProviderProducer.class;
        }
        if (capabilities.isPresent("io.quarkus.elasticsearch-rest-high-level-client")) {
            return JobRunrElasticSearchStorageProviderProducer.class;
        }
        return JobRunrInMemoryStorageProviderProducer.class;
    }
}

