/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.extension.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.quarkus.annotations.Recurring;
import org.jobrunr.scheduling.JobRunrRecurringJobRecorder;

public class RecurringJobsFinder {
    private final RecorderContext recorderContext;
    private final CombinedIndexBuildItem index;
    private final BeanContainerBuildItem beanContainer;
    private final JobRunrRecurringJobRecorder recorder;

    public RecurringJobsFinder(RecorderContext recorderContext, CombinedIndexBuildItem index, BeanContainerBuildItem beanContainer, JobRunrRecurringJobRecorder recorder) throws NoSuchMethodException {
        this.recorderContext = recorderContext;
        this.index = index;
        this.beanContainer = beanContainer;
        this.recorder = recorder;
        this.registerNonDefaultJobDetailsConstructor();
    }

    public void findRecurringJobsAndScheduleThem() {
        for (AnnotationInstance recurringJobAnnotation : this.index.getIndex().getAnnotations(DotName.createSimple((String)Recurring.class.getName()))) {
            AnnotationTarget annotationTarget = recurringJobAnnotation.target();
            if (!AnnotationTarget.Kind.METHOD.equals((Object)annotationTarget.kind())) continue;
            String id = this.getId(recurringJobAnnotation);
            String cron = this.getCron(recurringJobAnnotation);
            JobDetails jobDetails = this.getJobDetails(recurringJobAnnotation);
            String zoneId = this.getZoneId(recurringJobAnnotation);
            this.recorder.schedule(this.beanContainer.getValue(), id, jobDetails, cron, zoneId);
        }
    }

    private void registerNonDefaultJobDetailsConstructor() throws NoSuchMethodException {
        this.recorderContext.registerNonDefaultConstructor(JobDetails.class.getDeclaredConstructor(String.class, String.class, String.class, List.class), jobDetails -> Arrays.asList(jobDetails.getClassName(), jobDetails.getStaticFieldName(), jobDetails.getMethodName(), jobDetails.getJobParameters()));
    }

    private String getId(AnnotationInstance recurringJobAnnotation) {
        if (recurringJobAnnotation.value("id") != null) {
            return recurringJobAnnotation.value("id").asString();
        }
        return null;
    }

    private JobDetails getJobDetails(AnnotationInstance recurringJobAnnotation) {
        MethodInfo methodInfo = recurringJobAnnotation.target().asMethod();
        if (!methodInfo.parameters().isEmpty()) {
            throw new IllegalStateException("Methods annotated with " + Recurring.class.getName() + " can not have parameters.");
        }
        return new JobDetails(methodInfo.declaringClass().name().toString(), null, methodInfo.name(), new ArrayList());
    }

    private String getZoneId(AnnotationInstance recurringJobAnnotation) {
        if (recurringJobAnnotation.value("zoneId") != null) {
            return recurringJobAnnotation.value("zoneId").asString();
        }
        return null;
    }

    private String getCron(AnnotationInstance recurringJobAnnotation) {
        return recurringJobAnnotation.value("cron").asString();
    }
}

