/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.extension.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jobrunr.quarkus.autoconfigure.JobRunrConfiguration;
import org.jobrunr.quarkus.autoconfigure.JobRunrProducer;
import org.jobrunr.quarkus.autoconfigure.JobRunrStarter;
import org.jobrunr.quarkus.autoconfigure.health.JobRunrHealthCheck;
import org.jobrunr.quarkus.autoconfigure.metrics.JobRunrMetricsProducer;
import org.jobrunr.quarkus.autoconfigure.metrics.JobRunrMetricsStarter;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrDocumentDBStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrElasticSearchStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrInMemoryStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrMongoDBStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrSqlStorageProviderProducer;
import org.jobrunr.quarkus.extension.deployment.RecurringJobsFinder;
import org.jobrunr.scheduling.JobRunrRecurringJobRecorder;
import org.jobrunr.utils.CollectionUtils;

class JobRunrExtensionProcessor {
    private static final String FEATURE = "jobrunr";

    JobRunrExtensionProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem produce(Capabilities capabilities) {
        HashSet additionalBeans = new HashSet();
        additionalBeans.add(JobRunrProducer.class);
        additionalBeans.add(JobRunrStarter.class);
        additionalBeans.add(this.jsonMapper(capabilities));
        additionalBeans.add(JobRunrMetricsProducer.StorageProviderMetricsProducer.class);
        additionalBeans.addAll(this.storageProvider(capabilities));
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(additionalBeans.toArray(new Class[0])).build();
    }

    @BuildStep
    AdditionalBeanBuildItem addMetrics(Optional<MetricsCapabilityBuildItem> metricsCapability, JobRunrConfiguration jobRunrConfiguration) {
        if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer")) {
            AdditionalBeanBuildItem.Builder additionalBeanBuildItemBuilder = AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{JobRunrMetricsStarter.class}).addBeanClasses(new Class[]{JobRunrMetricsProducer.StorageProviderMetricsProducer.class});
            if (jobRunrConfiguration.backgroundJobServer.enabled) {
                additionalBeanBuildItemBuilder.addBeanClasses(new Class[]{JobRunrMetricsProducer.BackgroundJobServerMetricsProducer.class});
            }
            return additionalBeanBuildItemBuilder.build();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void findRecurringJobAnnotationsAndScheduleThem(RecorderContext recorderContext, CombinedIndexBuildItem index, BeanContainerBuildItem beanContainer, JobRunrRecurringJobRecorder recorder) throws NoSuchMethodException {
        new RecurringJobsFinder(recorderContext, index, beanContainer, recorder).findRecurringJobsAndScheduleThem();
    }

    @BuildStep
    HealthBuildItem addHealthCheck(Capabilities capabilities, JobRunrConfiguration jobRunrConfiguration) {
        if (capabilities.isPresent("io.quarkus.smallrye.health")) {
            return new HealthBuildItem(JobRunrHealthCheck.class.getName(), jobRunrConfiguration.healthEnabled);
        }
        return null;
    }

    private Class<?> jsonMapper(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.jsonb")) {
            return JobRunrProducer.JobRunrJsonBJsonMapperProducer.class;
        }
        if (capabilities.isPresent("io.quarkus.jackson")) {
            return JobRunrProducer.JobRunrJacksonJsonMapperProducer.class;
        }
        throw new IllegalStateException("Either JSON-B or Jackson should be added via a Quarkus extension");
    }

    private Set<Class<?>> storageProvider(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            return CollectionUtils.asSet((Object[])new Class[]{JobRunrSqlStorageProviderProducer.class});
        }
        if (capabilities.isPresent("io.quarkus.mongodb-client")) {
            return CollectionUtils.asSet((Object[])new Class[]{JobRunrMongoDBStorageProviderProducer.class, JobRunrDocumentDBStorageProviderProducer.class});
        }
        if (capabilities.isPresent("io.quarkus.elasticsearch-rest-high-level-client")) {
            return CollectionUtils.asSet((Object[])new Class[]{JobRunrElasticSearchStorageProviderProducer.class});
        }
        return CollectionUtils.asSet((Object[])new Class[]{JobRunrInMemoryStorageProviderProducer.class});
    }
}

