/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.extension.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceDirectoryBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.annotations.RegisterForReflection;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.annotations.Recurring;
import org.jobrunr.jobs.lambdas.JobRequest;
import org.jobrunr.jobs.lambdas.JobRequestHandler;
import org.jobrunr.quarkus.autoconfigure.JobRunrBuildTimeConfiguration;
import org.jobrunr.quarkus.autoconfigure.JobRunrProducer;
import org.jobrunr.quarkus.autoconfigure.JobRunrStarter;
import org.jobrunr.quarkus.autoconfigure.dashboard.JobRunrDashboardProducer;
import org.jobrunr.quarkus.autoconfigure.health.JobRunrHealthCheck;
import org.jobrunr.quarkus.autoconfigure.metrics.JobRunrMetricsProducer;
import org.jobrunr.quarkus.autoconfigure.metrics.JobRunrMetricsStarter;
import org.jobrunr.quarkus.autoconfigure.server.JobRunrBackgroundJobServerProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrDocumentDBStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrInMemoryStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrMongoDBStorageProviderProducer;
import org.jobrunr.quarkus.autoconfigure.storage.JobRunrSqlStorageProviderProducer;
import org.jobrunr.quarkus.extension.deployment.RecurringJobsFinder;
import org.jobrunr.scheduling.JobRunrRecurringJobRecorder;
import org.jobrunr.server.configuration.BackgroundJobServerThreadType;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.nosql.common.NoSqlDatabaseCreator;
import org.jobrunr.utils.CollectionUtils;
import org.jobrunr.utils.GraalVMUtils;
import org.jobrunr.utils.VersionNumber;

class JobRunrExtensionProcessor {
    private static final String FEATURE = "jobrunr";

    JobRunrExtensionProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem produce(Capabilities capabilities, JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration) {
        HashSet additionalBeans = new HashSet();
        additionalBeans.add(JobRunrProducer.class);
        additionalBeans.add(JobRunrStarter.class);
        additionalBeans.add(this.jsonMapper(capabilities));
        additionalBeans.addAll(this.storageProvider(capabilities, jobRunrBuildTimeConfiguration));
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(additionalBeans.toArray(new Class[0])).build();
    }

    @BuildStep
    AdditionalBeanBuildItem addBackgroundJobServer(JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration) {
        if (jobRunrBuildTimeConfiguration.backgroundJobServer().included()) {
            return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{JobRunrBackgroundJobServerProducer.class}).build();
        }
        return null;
    }

    @BuildStep
    AdditionalBeanBuildItem addDashboard(JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration) {
        if (jobRunrBuildTimeConfiguration.dashboard().included()) {
            return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{JobRunrDashboardProducer.class}).build();
        }
        return null;
    }

    @BuildStep
    public void registerRuntimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem(Job.class.getName()));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem(NoSqlDatabaseCreator.class.getName()));
    }

    @BuildStep
    AdditionalBeanBuildItem addMetrics(Optional<MetricsCapabilityBuildItem> metricsCapability, JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration) {
        if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer")) {
            AdditionalBeanBuildItem.Builder additionalBeanBuildItemBuilder = AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{JobRunrMetricsStarter.class}).addBeanClasses(new Class[]{JobRunrMetricsProducer.StorageProviderMetricsProducer.class});
            if (jobRunrBuildTimeConfiguration.backgroundJobServer().included()) {
                additionalBeanBuildItemBuilder.addBeanClasses(new Class[]{JobRunrMetricsProducer.BackgroundJobServerMetricsProducer.class});
            }
            return additionalBeanBuildItemBuilder.build();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void findRecurringJobAnnotationsAndScheduleThem(RecorderContext recorderContext, CombinedIndexBuildItem index, BeanContainerBuildItem beanContainer, JobRunrRecurringJobRecorder recorder) throws NoSuchMethodException {
        new RecurringJobsFinder(recorderContext, index, beanContainer, recorder).findRecurringJobsAndScheduleThem();
    }

    @BuildStep
    HealthBuildItem addHealthCheck(Capabilities capabilities, JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration) {
        if (capabilities.isPresent("io.quarkus.smallrye.health") && jobRunrBuildTimeConfiguration.backgroundJobServer().included()) {
            return new HealthBuildItem(JobRunrHealthCheck.class.getName(), jobRunrBuildTimeConfiguration.healthEnabled());
        }
        return null;
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableBeans() {
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{DotName.createSimple(JobRequestHandler.class)});
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, CombinedIndexBuildItem indexBuildItem) {
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])GraalVMUtils.JOBRUNR_CLASSES.stream().map(Class::getName).toArray(String[]::new))).methods().fields().build());
        if (BackgroundJobServerThreadType.VirtualThreads.isSupported(VersionNumber.JAVA_VERSION)) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{Thread.class.getName(), "java.lang.Thread$Builder", Executors.class.getName(), ExecutorService.class.getName()}).methods().fields().build());
        }
        Collection storageProviderImpls = indexBuildItem.getIndex().getAllKnownImplementors(StorageProvider.class);
        Collection jobRequestHandlerImpls = indexBuildItem.getIndex().getAllKnownImplementors(JobRequestHandler.class);
        Collection jobRequestImpls = indexBuildItem.getIndex().getAllKnownImplementors(JobRequest.class);
        List<ClassInfo> recurringClasses = indexBuildItem.getIndex().getAnnotations(DotName.createSimple(Recurring.class)).stream().map(annotationInstance -> annotationInstance.target().asMethod().declaringClass()).toList();
        String[] applicationClassNamesToRegister = (String[])Stream.of(storageProviderImpls.stream(), jobRequestHandlerImpls.stream(), jobRequestImpls.stream(), recurringClasses.stream()).flatMap(s -> s).map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        if (applicationClassNamesToRegister.length != 0) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])applicationClassNamesToRegister).methods().fields().build());
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void registerStaticResources(BuildProducer<NativeImageResourceDirectoryBuildItem> nativeImageResourceDirectoryProducer, JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration) {
        if (jobRunrBuildTimeConfiguration.dashboard().included()) {
            nativeImageResourceDirectoryProducer.produce((BuildItem)new NativeImageResourceDirectoryBuildItem("org/jobrunr/dashboard/frontend/build"));
        }
        if ("sql".equalsIgnoreCase(jobRunrBuildTimeConfiguration.database().type().orElse("sql"))) {
            nativeImageResourceDirectoryProducer.produce((BuildItem)new NativeImageResourceDirectoryBuildItem("org/jobrunr/storage/sql"));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void registerLambdaCapturingTypeResources(CombinedIndexBuildItem indexBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResource) {
        Collection registerForReflectionAnnotations = indexBuildItem.getIndex().getAnnotations(RegisterForReflection.class);
        for (AnnotationInstance annotationInstance : registerForReflectionAnnotations) {
            AnnotationValue lambdaCapturingTypes = annotationInstance.value("lambdaCapturingTypes");
            if (lambdaCapturingTypes == null) continue;
            for (AnnotationValue lambdaCapturingType : lambdaCapturingTypes.asArrayList()) {
                String classResource = lambdaCapturingType.asString().replace('.', '/') + ".class";
                nativeImageResource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{classResource}));
            }
        }
    }

    private Class<?> jsonMapper(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.jackson")) {
            return JobRunrProducer.JobRunrJacksonJsonMapperProducer.class;
        }
        if (capabilities.isPresent("io.quarkus.jsonb")) {
            return JobRunrProducer.JobRunrJsonBJsonMapperProducer.class;
        }
        throw new IllegalStateException("Either JSON-B or Jackson should be added via a Quarkus extension");
    }

    private Set<Class<?>> storageProvider(Capabilities capabilities, JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration) {
        String databaseType = jobRunrBuildTimeConfiguration.database().type().orElse(null);
        if ("sql".equalsIgnoreCase(databaseType) && !capabilities.isPresent("io.quarkus.agroal")) {
            throw new IllegalStateException("You configured 'sql' as a JobRunr Database Type but the AGROAL capability is not available");
        }
        if ("mongodb".equalsIgnoreCase(databaseType) && !capabilities.isPresent("io.quarkus.mongodb-client")) {
            throw new IllegalStateException("You configured 'mongodb' as a JobRunr Database Type but the MONGODB_CLIENT capability is not available");
        }
        if ("documentdb".equalsIgnoreCase(databaseType) && !capabilities.isPresent("io.quarkus.mongodb-client")) {
            throw new IllegalStateException("You configured 'documentdb' as a JobRunr Database Type but the MONGODB_CLIENT capability is not available");
        }
        if (JobRunrExtensionProcessor.isCapabilityPresentAndConfigured(capabilities, "io.quarkus.agroal", "sql", databaseType)) {
            return CollectionUtils.asSet((Object[])new Class[]{JobRunrSqlStorageProviderProducer.class});
        }
        if (JobRunrExtensionProcessor.isCapabilityPresentAndConfigured(capabilities, "io.quarkus.mongodb-client", "mongodb", databaseType)) {
            return CollectionUtils.asSet((Object[])new Class[]{JobRunrMongoDBStorageProviderProducer.class});
        }
        if (JobRunrExtensionProcessor.isCapabilityPresentAndConfigured(capabilities, "io.quarkus.mongodb-client", "documentdb", databaseType)) {
            return CollectionUtils.asSet((Object[])new Class[]{JobRunrDocumentDBStorageProviderProducer.class});
        }
        if ("mem".equalsIgnoreCase(databaseType)) {
            return CollectionUtils.asSet((Object[])new Class[]{JobRunrInMemoryStorageProviderProducer.class});
        }
        return Set.of();
    }

    private static boolean isCapabilityPresentAndConfigured(Capabilities capabilities, String capability, String requestedDatabaseType, String databaseType) {
        return capabilities.isPresent(capability) && (databaseType == null || requestedDatabaseType.equalsIgnoreCase(databaseType));
    }
}

