/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.joda.beans.maven.AbstractJodaBeansMojo;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="validate", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(goal="validate", phase=LifecyclePhase.PROCESS_SOURCES)
public class JodaBeansValidateMojo
extends AbstractJodaBeansMojo {
    @Parameter(alias="stopOnError", property="joda.beans.stopOnError", defaultValue="true")
    private boolean stopOnError = true;

    @Override
    protected List<String> buildArgs() {
        List<String> argsList = super.buildArgs();
        argsList.add("-nowrite");
        return argsList;
    }

    @Override
    protected void runTool(Class<?> toolClass, List<String> argsList, BuildContext buildContext) throws MojoExecutionException, MojoFailureException {
        this.logInfo("Joda-Bean validator started, directory: " + this.getSourceDir() + (this.getTestSourceDir().length() == 0 ? "" : ", test directory:" + this.getTestSourceDir()));
        int changes = this.runTool(toolClass, argsList);
        if (changes > 0) {
            if (this.stopOnError) {
                throw new MojoFailureException("Some Joda-Beans need to be re-generated (" + changes + " files)");
            }
            this.logInfo("*** Joda-Bean validator found " + changes + " beans in need of generation ***");
        } else {
            this.logInfo("Joda-Bean validator completed");
        }
    }

    private int runTool(Class<?> toolClass, List<String> argsList) throws MojoExecutionException, MojoFailureException {
        argsList.add(this.getSourceDir());
        int changedFileCount = 0;
        changedFileCount += this.runToolHandleChanges(toolClass, argsList, new File(this.getSourceDir()), new File(this.getClassesDir()));
        if (this.getTestSourceDir().length() > 0) {
            argsList.set(argsList.size() - 1, this.getTestSourceDir());
            changedFileCount += this.runToolHandleChanges(toolClass, argsList, new File(this.getTestSourceDir()), new File(this.getTestClassesDir()));
        }
        return changedFileCount;
    }
}

