/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.Scanner;
import org.joda.beans.maven.AbstractJodaBeansMojo;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractJodaBeansGenerateMojo
extends AbstractJodaBeansMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    protected void runTool(Class<?> toolClass, List<String> argsList, BuildContext buildContext) throws MojoExecutionException, MojoFailureException {
        Object args;
        File classesDir;
        File sourceDir;
        String[] changedSourceFiles = this.findFiles(buildContext, this.getSourceDir());
        String[] changedTestFiles = this.findFiles(buildContext, this.getTestSourceDir());
        int sourceFilesChanged = changedSourceFiles.length;
        int testFilesChanged = changedTestFiles.length;
        if (sourceFilesChanged == 0 && testFilesChanged == 0) {
            this.logInfo("No files changed");
            return;
        }
        this.logDebug("Files changed: main=" + sourceFilesChanged + ", test=" + testFilesChanged);
        this.logInfo("Joda-Bean generator started, directory: " + this.getSourceDir() + (this.getTestSourceDir().length() == 0 ? "" : ", test directory: " + this.getTestSourceDir()));
        int changedFileCount = 0;
        if (sourceFilesChanged > 0) {
            sourceDir = new File(this.getSourceDir());
            classesDir = new File(this.getClassesDir());
            String[] stringArray = changedSourceFiles;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String changedFile = stringArray[i];
                buildContext.removeMessages(new File(sourceDir, changedFile));
            }
            args = new ArrayList<String>(argsList);
            if (sourceFilesChanged == 1) {
                File file = new File(sourceDir, changedSourceFiles[0]);
                args.add(file.toString());
                this.logDebug("Single file: " + (String)args.get(args.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, (List<String>)args, sourceDir, classesDir);
            } else {
                args.add(this.getSourceDir());
                this.logDebug("All files: " + (String)args.get(args.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, (List<String>)args, sourceDir, classesDir);
            }
        }
        if (testFilesChanged > 0) {
            sourceDir = new File(this.getTestSourceDir());
            classesDir = new File(this.getTestClassesDir());
            for (String changedFile : changedTestFiles) {
                buildContext.removeMessages(new File(sourceDir, changedFile));
            }
            args = new ArrayList<String>(argsList);
            if (testFilesChanged == 1) {
                File file = new File(sourceDir, changedTestFiles[0]);
                args.add(file.toString());
                this.logDebug("Single test file: " + (String)args.get(args.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, (List<String>)args, sourceDir, classesDir);
            } else {
                args.add(this.getTestSourceDir());
                this.logDebug("All test files: " + (String)args.get(args.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, (List<String>)args, sourceDir, classesDir);
            }
        }
        this.logInfo("Joda-Bean generator completed, " + changedFileCount + " changed files");
    }

    private String[] findFiles(BuildContext buildContext, String dirStr) {
        File dir = new File(dirStr);
        if (dirStr.isEmpty() || !dir.exists()) {
            return EMPTY_STRING_ARRAY;
        }
        Scanner scanner = buildContext.newScanner(dir);
        scanner.setIncludes(new String[]{"**/*.java"});
        scanner.scan();
        String[] changedSourceFiles = scanner.getIncludedFiles();
        return changedSourceFiles;
    }
}

