/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.joda.beans.maven.AbstractJodaBeansMojo;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="validate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(goal="validate", phase=LifecyclePhase.GENERATE_SOURCES)
public class JodaBeansValidateMojo
extends AbstractJodaBeansMojo {
    @Parameter(alias="stopOnError", property="joda.beans.stopOnError", defaultValue="true")
    private boolean stopOnError = true;

    @Override
    protected List<String> buildArgs() {
        List<String> argsList = super.buildArgs();
        argsList.add("-nowrite");
        return argsList;
    }

    @Override
    protected void runTool(Class<?> toolClass, List<String> argsList, BuildContext buildContext) throws MojoExecutionException, MojoFailureException {
        Path sourceDirPath = Paths.get(this.getSourceDir(), new String[0]);
        this.logInfo("Joda-Bean validator started, directory: " + this.getSourceDir() + (this.getTestSourceDir().length() == 0 ? "" : ", test directory:" + this.getTestSourceDir()));
        List<File> changedFiles = this.runTool(toolClass, argsList);
        if (changedFiles.size() > 0) {
            if (this.stopOnError) {
                for (File file : changedFiles) {
                    this.getLog().warn((CharSequence)("Joda-Bean needs to be re-generated: " + sourceDirPath.relativize(JodaBeansValidateMojo.canonicalize(file).toPath())));
                }
                throw new MojoFailureException("Some Joda-Beans need to be re-generated (" + changedFiles.size() + " files)");
            }
            this.logInfo("*** Joda-Bean validator found " + changedFiles.size() + " beans in need of generation ***");
        } else {
            this.logInfo("Joda-Bean validator completed");
        }
    }

    private List<File> runTool(Class<?> toolClass, List<String> argsList) throws MojoExecutionException, MojoFailureException {
        argsList.add(this.getSourceDir());
        ArrayList<File> changedFiles = new ArrayList<File>();
        List<File> productionFilesChanged = this.runToolHandleChanges(toolClass, argsList, new File(this.getSourceDir()), new File(this.getClassesDir()));
        changedFiles.addAll(productionFilesChanged);
        if (this.getTestSourceDir().length() > 0) {
            argsList.set(argsList.size() - 1, this.getTestSourceDir());
            List<File> testFilesChanged = this.runToolHandleChanges(toolClass, argsList, new File(this.getTestSourceDir()), new File(this.getTestClassesDir()));
            changedFiles.addAll(testFilesChanged);
        }
        return changedFiles;
    }

    private static File canonicalize(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to canonicalize file: " + file, (Exception)ex);
        }
    }
}

