/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.joda.beans.gen.BeanGen;

public class BeanCodeGen {
    private final File file;
    private final String indent;
    private final String prefix;
    private final int verbosity;
    private final boolean write;

    public static void main(String[] args) {
        String indent = "    ";
        String prefix = "";
        boolean recurse = false;
        int verbosity = 1;
        boolean write = true;
        File file = null;
        try {
            if (args.length == 0) {
                throw new RuntimeException();
            }
            for (int i = 0; i < args.length - 1; ++i) {
                if (args[i].startsWith("-indent=tab")) {
                    indent = "\t";
                    continue;
                }
                if (args[i].startsWith("-indent=")) {
                    indent = "          ".substring(0, Integer.parseInt(args[i].substring(8)));
                    continue;
                }
                if (args[i].startsWith("-prefix=")) {
                    prefix = args[i].substring(8);
                    continue;
                }
                if (args[i].equals("-R")) {
                    recurse = true;
                    continue;
                }
                if (args[i].startsWith("-v=")) {
                    verbosity = Integer.parseInt(args[i].substring(3));
                    continue;
                }
                if (!args[i].equals("-nowrite")) continue;
                write = false;
            }
            file = new File(args[args.length - 1]);
        }
        catch (Exception ex) {
            System.out.println("Code generator");
            System.out.println("  Usage java org.joda.beans.gen.BeanCodeGen [file]");
            System.out.println("  Options");
            System.out.println("    -R                process all files recursively, default false");
            System.out.println("    -indent=tab       use a tab for indenting, default 4 spaces");
            System.out.println("    -indent=[n]       use n spaces for indenting, default 4");
            System.out.println("    -prefix=[p]       field prefix of p should be removed, no default");
            System.out.println("    -verbose=[v]      output logging with verbosity from 0 to 3, default 1");
            System.out.println("    -nowrite          output messages rather than writing, default is to write");
            System.exit(0);
        }
        try {
            List<File> files = BeanCodeGen.findFiles(file, recurse);
            int changed = 0;
            for (File child : files) {
                BeanCodeGen gen = new BeanCodeGen(child, indent, prefix, verbosity, write);
                changed += gen.process() ? 1 : 0;
            }
            System.out.println("Finished, found " + changed + " changed files");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println();
            ex.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private static List<File> findFiles(File parent, boolean recurse) {
        ArrayList<File> result = new ArrayList<File>();
        if (parent.isDirectory()) {
            File[] files;
            for (File child : files = parent.listFiles()) {
                if (!child.isFile() || !child.getName().endsWith(".java")) continue;
                result.add(child);
            }
            if (recurse) {
                for (File child : files) {
                    if (!child.isDirectory() || child.getName().startsWith(".")) continue;
                    result.addAll(BeanCodeGen.findFiles(child, recurse));
                }
            }
        } else if (parent.getName().endsWith(".java")) {
            result.add(parent);
        }
        return result;
    }

    public BeanCodeGen(File file, String indent, String prefix, int verbosity, boolean write) {
        this.file = file;
        this.indent = indent;
        this.prefix = prefix;
        this.verbosity = verbosity;
        this.write = write;
    }

    public boolean process() throws Exception {
        BeanGen gen;
        List<String> original = this.readFile();
        ArrayList<String> content = new ArrayList<String>(original);
        try {
            gen = new BeanGen(content, this.indent, this.prefix);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error in bean: " + this.file, ex);
        }
        if (gen.isBean()) {
            if (this.verbosity >= 2) {
                System.out.print(this.file + "  [processing]");
            }
            gen.process();
            if (!((Object)content).equals(original)) {
                if (this.write) {
                    if (this.verbosity >= 2) {
                        System.out.println(" [writing]");
                    } else if (this.verbosity == 1) {
                        System.out.println(this.file + "  [writing]");
                    }
                    this.writeFile(content);
                } else if (this.verbosity >= 2) {
                    System.out.println(" [changed not written]");
                } else if (this.verbosity == 1) {
                    System.out.println(this.file + "  [changed not written]");
                }
                return true;
            }
            if (this.verbosity >= 2) {
                System.out.println(" [no change]");
            }
        } else if (this.verbosity == 3) {
            System.out.println(this.file + "  [ignored]");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile() throws Exception {
        ArrayList<String> content = new ArrayList<String>(100);
        BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
        try {
            String line;
            while ((line = is.readLine()) != null) {
                content.add(line);
            }
            ArrayList<String> arrayList = content;
            return arrayList;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(List<String> content) throws Exception {
        PrintWriter os = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8")));
        try {
            for (String line : content) {
                os.println(line);
            }
        }
        finally {
            os.close();
        }
    }
}

